/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.AsynchronousResponseSettings;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.jetty9.DefaultMultipartRequestConfigurer;
import com.github.tomakehurst.wiremock.jetty9.JettyFaultInjectorFactory;
import com.github.tomakehurst.wiremock.jetty9.NotFoundHandler;
import com.github.tomakehurst.wiremock.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.servlet.MultipartRequestConfigurer;
import com.github.tomakehurst.wiremock.servlet.TrailingSlashFilter;
import com.github.tomakehurst.wiremock.servlet.WireMockHandlerDispatchingServlet;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import wiremock.com.google.common.base.Optional;
import wiremock.com.google.common.collect.ImmutableMap;
import wiremock.com.google.common.io.Resources;
import wiremock.javax.servlet.DispatcherType;
import wiremock.org.apache.commons.lang3.ArrayUtils;
import wiremock.org.eclipse.jetty.http.MimeTypes;
import wiremock.org.eclipse.jetty.io.NetworkTrafficListener;
import wiremock.org.eclipse.jetty.server.ConnectionFactory;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.HttpConnectionFactory;
import wiremock.org.eclipse.jetty.server.NetworkTrafficServerConnector;
import wiremock.org.eclipse.jetty.server.SecureRequestCustomizer;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.server.ServerConnector;
import wiremock.org.eclipse.jetty.server.SslConnectionFactory;
import wiremock.org.eclipse.jetty.server.handler.HandlerCollection;
import wiremock.org.eclipse.jetty.server.handler.HandlerWrapper;
import wiremock.org.eclipse.jetty.servlet.DefaultServlet;
import wiremock.org.eclipse.jetty.servlet.FilterHolder;
import wiremock.org.eclipse.jetty.servlet.ServletContextHandler;
import wiremock.org.eclipse.jetty.servlet.ServletHolder;
import wiremock.org.eclipse.jetty.servlets.CrossOriginFilter;
import wiremock.org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyHttpServer
implements HttpServer {
    private static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    private static final String[] GZIPPABLE_METHODS = new String[]{"POST", "PUT", "PATCH", "DELETE"};
    private static final int DEFAULT_ACCEPTORS = 3;
    private final Server jettyServer;
    private final ServerConnector httpConnector;
    private final ServerConnector httpsConnector;
    private ScheduledExecutorService scheduledExecutorService;

    public JettyHttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        this.jettyServer = this.createServer(options);
        NetworkTrafficListenerAdapter networkTrafficListenerAdapter = new NetworkTrafficListenerAdapter(options.networkTrafficListener());
        if (options.getHttpDisabled()) {
            this.httpConnector = null;
        } else {
            this.httpConnector = this.createHttpConnector(options.bindAddress(), options.portNumber(), options.jettySettings(), networkTrafficListenerAdapter);
            this.jettyServer.addConnector(this.httpConnector);
        }
        if (options.httpsSettings().enabled()) {
            this.httpsConnector = this.createHttpsConnector(this.jettyServer, options.bindAddress(), options.httpsSettings(), options.jettySettings(), networkTrafficListenerAdapter);
            this.jettyServer.addConnector(this.httpsConnector);
        } else {
            this.httpsConnector = null;
        }
        this.jettyServer.setHandler(this.createHandler(options, adminRequestHandler, stubRequestHandler));
        this.finalizeSetup(options);
    }

    protected HandlerCollection createHandler(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        Notifier notifier = options.notifier();
        ServletContextHandler adminContext = this.addAdminContext(adminRequestHandler, notifier);
        ServletContextHandler mockServiceContext = this.addMockServiceContext(stubRequestHandler, options.filesRoot(), options.getAsynchronousResponseSettings(), options.getChunkedEncodingPolicy(), options.getStubCorsEnabled(), notifier);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(ArrayUtils.addAll(this.extensionHandlers(), adminContext));
        if (options.getGzipDisabled()) {
            handlers.addHandler(mockServiceContext);
        } else {
            this.addGZipHandler(mockServiceContext, handlers);
        }
        return handlers;
    }

    private void addGZipHandler(ServletContextHandler mockServiceContext, HandlerCollection handlers) {
        Class<?> gzipHandlerClass = null;
        try {
            gzipHandlerClass = Class.forName("wiremock.org.eclipse.jetty.servlets.gzip.GzipHandler");
        }
        catch (ClassNotFoundException e) {
            try {
                gzipHandlerClass = Class.forName("wiremock.org.eclipse.jetty.server.handler.gzip.GzipHandler");
            }
            catch (ClassNotFoundException e1) {
                Exceptions.throwUnchecked(e1);
            }
        }
        try {
            HandlerWrapper gzipWrapper = (HandlerWrapper)gzipHandlerClass.newInstance();
            JettyHttpServer.setGZippableMethods(gzipWrapper, gzipHandlerClass);
            gzipWrapper.setHandler(mockServiceContext);
            handlers.addHandler(gzipWrapper);
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }

    private static void setGZippableMethods(HandlerWrapper gzipHandler, Class<?> gzipHandlerClass) {
        try {
            Method addIncludedMethods = gzipHandlerClass.getDeclaredMethod("addIncludedMethods", String[].class);
            addIncludedMethods.invoke((Object)gzipHandler, new Object[]{GZIPPABLE_METHODS});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalizeSetup(Options options) {
        if (!options.jettySettings().getStopTimeout().isPresent()) {
            this.jettyServer.setStopTimeout(0L);
        }
    }

    protected Server createServer(Options options) {
        Server server = new Server(options.threadPoolFactory().buildThreadPool(options));
        JettySettings jettySettings = options.jettySettings();
        Optional<Long> stopTimeout = jettySettings.getStopTimeout();
        if (stopTimeout.isPresent()) {
            server.setStopTimeout(stopTimeout.get());
        }
        return server;
    }

    protected Handler[] extensionHandlers() {
        return new Handler[0];
    }

    @Override
    public void start() {
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long timeout = System.currentTimeMillis() + 30000L;
        while (!this.jettyServer.isStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeout) continue;
            throw new RuntimeException("Server took too long to start up.");
        }
    }

    @Override
    public void stop() {
        try {
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdown();
            }
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.jettyServer.isRunning();
    }

    @Override
    public int port() {
        return this.httpConnector.getLocalPort();
    }

    @Override
    public int httpsPort() {
        return this.httpsConnector.getLocalPort();
    }

    public long stopTimeout() {
        return this.jettyServer.getStopTimeout();
    }

    protected ServerConnector createHttpConnector(String bindAddress, int port, JettySettings jettySettings, NetworkTrafficListener listener) {
        HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
        ServerConnector connector = this.createServerConnector(bindAddress, jettySettings, port, listener, new HttpConnectionFactory(httpConfig));
        return connector;
    }

    protected ServerConnector createHttpsConnector(Server server, String bindAddress, HttpsSettings httpsSettings, JettySettings jettySettings, NetworkTrafficListener listener) {
        SslContextFactory sslContextFactory = this.buildSslContextFactory();
        sslContextFactory.setKeyStorePath(httpsSettings.keyStorePath());
        sslContextFactory.setKeyStorePassword(httpsSettings.keyStorePassword());
        sslContextFactory.setKeyManagerPassword(httpsSettings.keyManagerPassword());
        sslContextFactory.setKeyStoreType(httpsSettings.keyStoreType());
        if (httpsSettings.hasTrustStore()) {
            sslContextFactory.setTrustStorePath(httpsSettings.trustStorePath());
            sslContextFactory.setTrustStorePassword(httpsSettings.trustStorePassword());
        }
        sslContextFactory.setNeedClientAuth(httpsSettings.needClientAuth());
        HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
        httpConfig.addCustomizer(new SecureRequestCustomizer());
        int port = httpsSettings.port();
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, "http/1.1");
        ConnectionFactory[] connectionFactories = ArrayUtils.addAll(new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory}, this.buildAdditionalConnectionFactories(httpsSettings, httpConnectionFactory, sslConnectionFactory));
        return this.createServerConnector(bindAddress, jettySettings, port, listener, connectionFactories);
    }

    protected ConnectionFactory[] buildAdditionalConnectionFactories(HttpsSettings httpsSettings, HttpConnectionFactory httpConnectionFactory, SslConnectionFactory sslConnectionFactory) {
        return new ConnectionFactory[0];
    }

    protected SslContextFactory buildSslContextFactory() {
        return new SslContextFactory();
    }

    protected HttpConfiguration createHttpConfig(JettySettings jettySettings) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setRequestHeaderSize(jettySettings.getRequestHeaderSize().or(8192));
        httpConfig.setSendDateHeader(false);
        return httpConfig;
    }

    protected ServerConnector createServerConnector(String bindAddress, JettySettings jettySettings, int port, NetworkTrafficListener listener, ConnectionFactory ... connectionFactories) {
        int acceptors = jettySettings.getAcceptors().or(3);
        NetworkTrafficServerConnector connector = new NetworkTrafficServerConnector(this.jettyServer, null, null, null, acceptors, 2, connectionFactories);
        connector.setPort(port);
        connector.addNetworkTrafficListener(listener);
        this.setJettySettings(jettySettings, connector);
        connector.setHost(bindAddress);
        return connector;
    }

    private void setJettySettings(JettySettings jettySettings, ServerConnector connector) {
        if (jettySettings.getAcceptQueueSize().isPresent()) {
            connector.setAcceptQueueSize(jettySettings.getAcceptQueueSize().get());
        }
    }

    private ServletContextHandler addMockServiceContext(StubRequestHandler stubRequestHandler, FileSource fileSource, AsynchronousResponseSettings asynchronousResponseSettings, Options.ChunkedEncodingPolicy chunkedEncodingPolicy, boolean stubCorsEnabled, Notifier notifier) {
        ServletContextHandler mockServiceContext = new ServletContextHandler(this.jettyServer, "/");
        mockServiceContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        mockServiceContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.resourceBase", fileSource.getPath());
        mockServiceContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        mockServiceContext.setAttribute(JettyFaultInjectorFactory.class.getName(), new JettyFaultInjectorFactory());
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", notifier);
        mockServiceContext.setAttribute(Options.ChunkedEncodingPolicy.class.getName(), (Object)chunkedEncodingPolicy);
        ServletHolder servletHolder = mockServiceContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("FaultHandlerFactoryClass", JettyFaultInjectorFactory.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        if (asynchronousResponseSettings.isEnabled()) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(asynchronousResponseSettings.getThreads());
            mockServiceContext.setAttribute(WireMockHandlerDispatchingServlet.ASYNCHRONOUS_RESPONSE_EXECUTOR, this.scheduledExecutorService);
        }
        mockServiceContext.setAttribute(MultipartRequestConfigurer.KEY, this.buildMultipartRequestConfigurer());
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mockServiceContext.setMimeTypes(mimeTypes);
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        NotFoundHandler errorHandler = new NotFoundHandler(mockServiceContext);
        mockServiceContext.setErrorHandler(errorHandler);
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, EnumSet.of(DispatcherType.FORWARD));
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, EnumSet.allOf(DispatcherType.class));
        if (stubCorsEnabled) {
            this.addCorsFilter(mockServiceContext);
        }
        return mockServiceContext;
    }

    private ServletContextHandler addAdminContext(AdminRequestHandler adminRequestHandler, Notifier notifier) {
        ServletContextHandler adminContext = new ServletContextHandler(this.jettyServer, "/__admin");
        adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor != null && javaVendor.toLowerCase().contains("android")) {
            adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.resourceBase", "assets");
        } else {
            adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.resourceBase", Resources.getResource("assets").toString());
        }
        Resources.getResource("assets/swagger-ui/index.html");
        adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        adminContext.addServlet(DefaultServlet.class, "/swagger-ui/*");
        adminContext.addServlet(DefaultServlet.class, "/recorder/*");
        ServletHolder servletHolder = adminContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), adminRequestHandler);
        adminContext.setAttribute("Notifier", notifier);
        adminContext.setAttribute(MultipartRequestConfigurer.KEY, this.buildMultipartRequestConfigurer());
        this.addCorsFilter(adminContext);
        return adminContext;
    }

    private void addCorsFilter(ServletContextHandler context) {
        context.addFilter(this.buildCorsFilter(), "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private FilterHolder buildCorsFilter() {
        FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
        filterHolder.setInitParameters(ImmutableMap.of("chainPreflight", "false", "allowedOrigins", "*", "allowedHeaders", "*", "allowedMethods", "OPTIONS,GET,POST,PUT,PATCH,DELETE"));
        return filterHolder;
    }

    protected MultipartRequestConfigurer buildMultipartRequestConfigurer() {
        return new DefaultMultipartRequestConfigurer();
    }

    static {
        System.setProperty("wiremock.org.eclipse.jetty.server.HttpChannelState.DEFAULT_TIMEOUT", "300000");
    }

    private static class NetworkTrafficListenerAdapter
    implements NetworkTrafficListener {
        private final WiremockNetworkTrafficListener wiremockNetworkTrafficListener;

        NetworkTrafficListenerAdapter(WiremockNetworkTrafficListener wiremockNetworkTrafficListener) {
            this.wiremockNetworkTrafficListener = wiremockNetworkTrafficListener;
        }

        @Override
        public void opened(Socket socket) {
            this.wiremockNetworkTrafficListener.opened(socket);
        }

        @Override
        public void incoming(Socket socket, ByteBuffer bytes) {
            this.wiremockNetworkTrafficListener.incoming(socket, bytes);
        }

        @Override
        public void outgoing(Socket socket, ByteBuffer bytes) {
            this.wiremockNetworkTrafficListener.outgoing(socket, bytes);
        }

        @Override
        public void closed(Socket socket) {
            this.wiremockNetworkTrafficListener.closed(socket);
        }
    }
}

