/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.server;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import wiremock.org.eclipse.jetty.http.BadMessageException;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpMethod;
import wiremock.org.eclipse.jetty.http.MetaData;
import wiremock.org.eclipse.jetty.http2.ErrorCode;
import wiremock.org.eclipse.jetty.http2.HTTP2Connection;
import wiremock.org.eclipse.jetty.http2.ISession;
import wiremock.org.eclipse.jetty.http2.IStream;
import wiremock.org.eclipse.jetty.http2.api.Stream;
import wiremock.org.eclipse.jetty.http2.api.server.ServerSessionListener;
import wiremock.org.eclipse.jetty.http2.frames.DataFrame;
import wiremock.org.eclipse.jetty.http2.frames.Frame;
import wiremock.org.eclipse.jetty.http2.frames.HeadersFrame;
import wiremock.org.eclipse.jetty.http2.frames.PrefaceFrame;
import wiremock.org.eclipse.jetty.http2.frames.ResetFrame;
import wiremock.org.eclipse.jetty.http2.frames.SettingsFrame;
import wiremock.org.eclipse.jetty.http2.parser.ServerParser;
import wiremock.org.eclipse.jetty.http2.parser.SettingsBodyParser;
import wiremock.org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import wiremock.org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import wiremock.org.eclipse.jetty.io.ByteBufferPool;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.CountingCallback;
import wiremock.org.eclipse.jetty.util.TypeUtil;

public class HTTP2ServerConnection
extends HTTP2Connection
implements Connection.UpgradeTo {
    private final Queue<HttpChannelOverHTTP2> channels = new ArrayDeque<HttpChannelOverHTTP2>();
    private final List<Frame> upgradeFrames = new ArrayList<Frame>();
    private final AtomicLong totalRequests = new AtomicLong();
    private final AtomicLong totalResponses = new AtomicLong();
    private final ServerSessionListener listener;
    private final HttpConfiguration httpConfig;
    private boolean recycleHttpChannels;

    public static boolean isSupportedProtocol(String protocol) {
        switch (protocol) {
            case "h2": 
            case "h2-17": 
            case "h2-16": 
            case "h2-15": 
            case "h2-14": 
            case "h2c": 
            case "h2c-17": 
            case "h2c-16": 
            case "h2c-15": 
            case "h2c-14": {
                return true;
            }
        }
        return false;
    }

    public HTTP2ServerConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, HttpConfiguration httpConfig, ServerParser parser, ISession session, int inputBufferSize, ServerSessionListener listener) {
        super(byteBufferPool, executor, endPoint, parser, session, inputBufferSize);
        this.listener = listener;
        this.httpConfig = httpConfig;
    }

    @Override
    public long getMessagesIn() {
        return this.totalRequests.get();
    }

    @Override
    public long getMessagesOut() {
        return this.totalResponses.get();
    }

    @Override
    protected ServerParser getParser() {
        return (ServerParser)super.getParser();
    }

    public boolean isRecycleHttpChannels() {
        return this.recycleHttpChannels;
    }

    public void setRecycleHttpChannels(boolean recycleHttpChannels) {
        this.recycleHttpChannels = recycleHttpChannels;
    }

    @Override
    public void onUpgradeTo(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onUpgradeTo {} {}", this, BufferUtil.toDetailString(buffer));
        }
        this.setInputBuffer(buffer);
    }

    @Override
    public void onOpen() {
        this.notifyAccept(this.getSession());
        for (Frame frame : this.upgradeFrames) {
            this.getSession().onFrame(frame);
        }
        super.onOpen();
        this.produce();
    }

    private void notifyAccept(ISession session) {
        try {
            this.listener.onAccept(session);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    public void onNewStream(Connector connector, IStream stream, HeadersFrame frame) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", frame, stream);
        }
        if ((task = (channel = this.provideHttpChannel(connector, stream)).onRequest(frame)) != null) {
            this.offerTask(task, false);
        }
    }

    public void onData(IStream stream, DataFrame frame, Callback callback) {
        HttpChannelOverHTTP2 channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", frame, stream);
        }
        if ((channel = (HttpChannelOverHTTP2)stream.getAttachment()) != null) {
            Runnable task = channel.onRequestContent(frame, callback);
            if (task != null) {
                this.offerTask(task, false);
            }
        } else {
            callback.failed(new IOException("channel_not_found"));
        }
    }

    public void onTrailers(IStream stream, HeadersFrame frame) {
        Runnable task;
        HttpChannelOverHTTP2 channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing trailers {} on {}", frame, stream);
        }
        if ((channel = (HttpChannelOverHTTP2)stream.getAttachment()) != null && (task = channel.onRequestTrailers(frame)) != null) {
            this.offerTask(task, false);
        }
    }

    public boolean onStreamTimeout(IStream stream, Throwable failure) {
        boolean result;
        HttpChannelOverHTTP2 channel = (HttpChannelOverHTTP2)stream.getAttachment();
        boolean bl = result = channel != null && channel.onStreamTimeout(failure, (Runnable task) -> this.offerTask((Runnable)task, true));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} idle timeout on {}: {}", result ? "Processed" : "Ignored", stream, failure);
        }
        return result;
    }

    public void onStreamFailure(IStream stream, Throwable failure, Callback callback) {
        HttpChannelOverHTTP2 channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing failure on {}: {}", stream, failure);
        }
        if ((channel = (HttpChannelOverHTTP2)stream.getAttachment()) != null) {
            Runnable task = channel.onFailure(failure, callback);
            if (task != null) {
                this.offerTask(task, true);
            }
        } else {
            callback.succeeded();
        }
    }

    public boolean onSessionTimeout(Throwable failure) {
        ISession session = this.getSession();
        boolean result = session.getStreams().stream().map(stream -> (IStream)stream).map(stream -> (HttpChannelOverHTTP2)stream.getAttachment()).filter(Objects::nonNull).map(HttpChannelOverHTTP2::isRequestIdle).reduce(true, Boolean::logicalAnd);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} idle timeout on {}: {}", result ? "Processed" : "Ignored", session, failure);
        }
        return result;
    }

    public void onSessionFailure(Throwable failure, Callback callback) {
        Collection<Stream> streams;
        ISession session = this.getSession();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing failure on {}: {}", session, failure);
        }
        if ((streams = session.getStreams()).isEmpty()) {
            callback.succeeded();
        } else {
            CountingCallback counter = new CountingCallback(callback, streams.size());
            for (Stream stream : streams) {
                this.onStreamFailure((IStream)stream, failure, counter);
            }
        }
    }

    public void push(Connector connector, IStream stream, MetaData.Request request) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing push {} on {}", request, stream);
        }
        if ((task = (channel = this.provideHttpChannel(connector, stream)).onPushRequest(request)) != null) {
            this.offerTask(task, true);
        }
    }

    private HttpChannelOverHTTP2 provideHttpChannel(Connector connector, IStream stream) {
        HttpChannelOverHTTP2 channel = this.pollHttpChannel();
        if (channel != null) {
            channel.getHttpTransport().setStream(stream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Recycling channel {} for {}", channel, this);
            }
        } else {
            HttpTransportOverHTTP2 transport = new HttpTransportOverHTTP2(connector, this);
            transport.setStream(stream);
            channel = this.newServerHttpChannelOverHTTP2(connector, this.httpConfig, transport);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating channel {} for {}", channel, this);
            }
        }
        stream.setAttachment(channel);
        return channel;
    }

    protected ServerHttpChannelOverHTTP2 newServerHttpChannelOverHTTP2(Connector connector, HttpConfiguration httpConfig, HttpTransportOverHTTP2 transport) {
        return new ServerHttpChannelOverHTTP2(connector, httpConfig, this.getEndPoint(), transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerHttpChannel(HttpChannelOverHTTP2 channel) {
        if (this.isRecycleHttpChannels()) {
            HTTP2ServerConnection hTTP2ServerConnection = this;
            synchronized (hTTP2ServerConnection) {
                this.channels.offer(channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpChannelOverHTTP2 pollHttpChannel() {
        if (this.isRecycleHttpChannels()) {
            HTTP2ServerConnection hTTP2ServerConnection = this;
            synchronized (hTTP2ServerConnection) {
                return this.channels.poll();
            }
        }
        return null;
    }

    public boolean upgrade(MetaData.Request request) {
        if (HttpMethod.PRI.is(request.getMethod())) {
            this.getParser().directUpgrade();
        } else {
            SettingsFrame settingsFrame;
            HttpField settingsField = request.getFields().getField(HttpHeader.HTTP2_SETTINGS);
            if (settingsField == null) {
                throw new BadMessageException("Missing " + (Object)((Object)HttpHeader.HTTP2_SETTINGS) + " header");
            }
            String value = settingsField.getValue();
            byte[] settings = Base64.getUrlDecoder().decode(value == null ? "" : value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} settings {}", this, TypeUtil.toHexString(settings));
            }
            if ((settingsFrame = SettingsBodyParser.parseBody(BufferUtil.toBuffer(settings))) == null) {
                LOG.warn("Invalid {} header value: {}", new Object[]{HttpHeader.HTTP2_SETTINGS, value});
                throw new BadMessageException();
            }
            this.getParser().standardUpgrade();
            this.upgradeFrames.add(new PrefaceFrame());
            this.upgradeFrames.add(settingsFrame);
            this.upgradeFrames.add(new HeadersFrame(1, new MetaData.Request(request), null, true));
        }
        return true;
    }

    protected class ServerHttpChannelOverHTTP2
    extends HttpChannelOverHTTP2
    implements Closeable {
        public ServerHttpChannelOverHTTP2(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP2 transport) {
            super(connector, configuration, endPoint, transport);
        }

        @Override
        public Runnable onRequest(HeadersFrame frame) {
            HTTP2ServerConnection.this.totalRequests.incrementAndGet();
            return super.onRequest(frame);
        }

        @Override
        public void onCompleted() {
            HTTP2ServerConnection.this.totalResponses.incrementAndGet();
            super.onCompleted();
            if (!this.getStream().isReset()) {
                this.recycle();
            }
        }

        @Override
        public void recycle() {
            this.getStream().setAttachment(null);
            super.recycle();
            HTTP2ServerConnection.this.offerHttpChannel(this);
        }

        @Override
        public void close() {
            IStream stream = this.getStream();
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Request #{}/{} rejected", stream.getId(), Integer.toHexString(stream.getSession().hashCode()));
            }
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.ENHANCE_YOUR_CALM_ERROR.code), Callback.NOOP);
            this.consumeInput();
        }
    }
}

