/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal.matchers;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import wiremock.net.javacrumbs.jsonunit.core.Configuration;
import wiremock.net.javacrumbs.jsonunit.core.ConfigurationWhen;
import wiremock.net.javacrumbs.jsonunit.core.Option;
import wiremock.net.javacrumbs.jsonunit.core.internal.Diff;
import wiremock.net.javacrumbs.jsonunit.core.internal.JsonUtils;
import wiremock.net.javacrumbs.jsonunit.core.internal.Node;
import wiremock.net.javacrumbs.jsonunit.core.internal.Path;
import wiremock.net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import wiremock.org.hamcrest.Matcher;
import wiremock.org.hamcrest.MatcherAssert;

public final class InternalMatcher {
    public static final String ACTUAL = "actual";
    private final Path path;
    private final Object actual;
    private final String description;
    private final Configuration configuration;

    public InternalMatcher(Object actual, Path path, String description, Configuration configuration) {
        if (actual == null) {
            throw new IllegalArgumentException("Can not make assertions about null JSON.");
        }
        this.path = path;
        this.actual = actual;
        this.description = description;
        this.configuration = configuration;
    }

    private InternalMatcher(Object actual, String pathPrefix) {
        this(actual, Path.create("", pathPrefix), "", Configuration.empty());
    }

    public InternalMatcher whenIgnoringPaths(String ... pathsToBeIgnored) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.whenIgnoringPaths(pathsToBeIgnored));
    }

    public InternalMatcher describedAs(String description) {
        return new InternalMatcher(this.actual, this.path, description, this.configuration);
    }

    public InternalMatcher withIgnorePlaceholder(String ignorePlaceholder) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    public InternalMatcher withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public InternalMatcher withTolerance(BigDecimal tolerance) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.withTolerance(tolerance));
    }

    public InternalMatcher withMatcher(String matcherName, Matcher<?> matcher) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.withMatcher(matcherName, matcher));
    }

    public InternalMatcher withDifferenceListener(DifferenceListener differenceListener) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.withDifferenceListener(differenceListener));
    }

    public InternalMatcher withOptions(Option firstOption, Option ... otherOptions) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.withOptions(firstOption, otherOptions));
    }

    public final <T> InternalMatcher when(ConfigurationWhen.PathsParam object, ConfigurationWhen.ApplicableForPath ... actions) {
        return new InternalMatcher(this.actual, this.path, this.description, this.configuration.when(object, actions));
    }

    public void isEqualTo(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        diff.failIfDifferent(this.description);
    }

    public void isStringEqualTo(String expected) {
        this.isString();
        Node node = JsonUtils.getNode(this.actual, this.path);
        if (!node.asText().equals(expected)) {
            this.failOnDifference(Diff.quoteTextValue(expected), Diff.quoteTextValue(node.asText()));
        }
    }

    private void failOnDifference(Object expected, Object actual) {
        this.failWithMessage(String.format("Different value found in node \"%s\", expected: <%s> but was: <%s>.", this.path, expected, actual));
    }

    public void isNotEqualTo(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        if (diff.similar()) {
            this.failWithMessage("JSON is equal.");
        }
    }

    public void hasSameStructureAs(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration.withOptions(Option.COMPARING_ONLY_STRUCTURE, new Option[0]));
        diff.failIfDifferent();
    }

    public InternalMatcher node(String newPath) {
        return new InternalMatcher(this.actual, this.path.copy(newPath), this.description, this.configuration);
    }

    private Diff createDiff(Object expected, Configuration configuration) {
        return Diff.create(expected, this.actual, ACTUAL, this.path, configuration);
    }

    private void failWithMessage(String message) {
        if (this.description != null && this.description.length() > 0) {
            throw new AssertionError((Object)("[" + this.description + "] " + message));
        }
        throw new AssertionError((Object)message);
    }

    public void isAbsent() {
        if (!JsonUtils.nodeAbsent(this.actual, this.path, this.configuration)) {
            this.failOnDifference("node to be absent", Diff.quoteTextValue(JsonUtils.getNode(this.actual, this.path)));
        }
    }

    public void isPresent() {
        this.isPresent("node to be present");
    }

    public void isPresent(String expectedValue) {
        if (JsonUtils.nodeAbsent(this.actual, this.path, this.configuration)) {
            this.failOnDifference(expectedValue, "missing");
        }
    }

    public ArrayMatcher isArray() {
        Node node = this.assertType(Node.NodeType.ARRAY);
        return new ArrayMatcher(node.arrayElements());
    }

    public Node assertType(Node.NodeType type) {
        this.isPresent(type.getDescription());
        Node node = JsonUtils.getNode(this.actual, this.path);
        if (node.getNodeType() != type) {
            this.failOnType(node, type);
        }
        return node;
    }

    public void isObject() {
        this.assertType(Node.NodeType.OBJECT);
    }

    public void isString() {
        this.assertType(Node.NodeType.STRING);
    }

    public void isNull() {
        this.isPresent();
        Node node = JsonUtils.getNode(this.actual, this.path);
        if (node.getNodeType() != Node.NodeType.NULL) {
            this.failOnType(node, "a null");
        }
    }

    public void isNotNull() {
        this.isPresent("not null");
        Node node = JsonUtils.getNode(this.actual, this.path);
        if (node.getNodeType() == Node.NodeType.NULL) {
            this.failOnType(node, "not null");
        }
    }

    private void failOnType(Node node, Node.NodeType expectedType) {
        this.failOnType(node, expectedType.getDescription());
    }

    public void failOnType(Node node, String expectedType) {
        this.failWithMessage("Node \"" + this.path + "\" has invalid type, expected: <" + expectedType + "> but was: <" + Diff.quoteTextValue(node.getValue()) + ">.");
    }

    public void matches(Matcher<?> matcher) {
        this.isPresent();
        InternalMatcher.match(this.actual, this.path, matcher);
    }

    private static void match(Object value, Path path, Matcher<?> matcher) {
        Node node = JsonUtils.getNode(value, path);
        MatcherAssert.assertThat("Node \"" + path + "\" does not match.", node.getValue(), matcher);
    }

    public class ArrayMatcher {
        private final List<Node> array;

        ArrayMatcher(Iterator<Node> array) {
            ArrayList<Node> list = new ArrayList<Node>();
            while (array.hasNext()) {
                list.add(array.next());
            }
            this.array = list;
        }

        public void ofLength(int expectedLength) {
            if (this.array.size() != expectedLength) {
                InternalMatcher.this.failWithMessage("Node \"" + InternalMatcher.this.path + "\" has invalid length, expected: <" + expectedLength + "> but was: <" + this.array.size() + ">.");
            }
        }

        public void thatContains(Object expected) {
            for (Node node : this.array) {
                Diff diff = Diff.create(expected, (Object)node, InternalMatcher.ACTUAL, "", InternalMatcher.this.configuration);
                if (!diff.similar()) continue;
                return;
            }
            InternalMatcher.this.failWithMessage("Node \"" + InternalMatcher.this.path + "\" is '" + this.array.toString() + "', expected to contain '" + expected + "'.");
        }

        public void isEmpty() {
            if (!this.array.isEmpty()) {
                InternalMatcher.this.failWithMessage("Node \"" + InternalMatcher.this.path + "\" is not an empty array.");
            }
        }

        public void isNotEmpty() {
            if (this.array.isEmpty()) {
                InternalMatcher.this.failWithMessage("Node \"" + InternalMatcher.this.path + "\" is an empty array.");
            }
        }
    }
}

