/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.AbstractFileSource;
import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import wiremock.com.google.common.collect.Iterables;
import wiremock.org.apache.commons.lang3.StringUtils;

public class RemoteMappingsLoader {
    private final FileSource mappingsFileSource;
    private final FileSource filesFileSource;
    private final WireMock wireMock;

    public RemoteMappingsLoader(FileSource fileSource, WireMock wireMock) {
        this.mappingsFileSource = fileSource.child("mappings");
        this.filesFileSource = fileSource.child("__files");
        this.wireMock = wireMock;
    }

    public void load() {
        Iterable<BinaryFile> mappingFiles = Iterables.filter(this.mappingsFileSource.listFilesRecursively(), AbstractFileSource.byFileExtension("json"));
        for (TextFile textFile : mappingFiles) {
            StubMapping mapping = StubMapping.buildFrom(textFile.readContentsAsString());
            this.convertBodyFromFileIfNecessary(mapping);
            this.wireMock.register(mapping);
        }
    }

    private void convertBodyFromFileIfNecessary(StubMapping mapping) {
        String bodyFileName = mapping.getResponse().getBodyFileName();
        if (bodyFileName != null) {
            String mimeType;
            ResponseDefinitionBuilder responseDefinitionBuilder = ResponseDefinitionBuilder.like(mapping.getResponse()).withBodyFile(null);
            String extension = StringUtils.substringAfterLast(bodyFileName, ".");
            if (ContentTypes.determineIsText(extension, mimeType = this.getMimeType(mapping))) {
                TextFile bodyFile = this.filesFileSource.getTextFileNamed(bodyFileName);
                responseDefinitionBuilder.withBody(bodyFile.readContentsAsString());
            } else {
                BinaryFile bodyFile = this.filesFileSource.getBinaryFileNamed(bodyFileName);
                responseDefinitionBuilder.withBody(bodyFile.readContents());
            }
            mapping.setResponse(responseDefinitionBuilder.build());
        }
    }

    private String getMimeType(StubMapping mapping) {
        HttpHeaders responseHeaders = mapping.getResponse().getHeaders();
        if (responseHeaders != null) {
            ContentTypeHeader contentTypeHeader = responseHeaders.getContentTypeHeader();
            return contentTypeHeader != null ? contentTypeHeader.mimeTypePart() : null;
        }
        return null;
    }
}

