/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import wiremock.org.eclipse.jetty.http.HostPortHttpField;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpScheme;
import wiremock.org.eclipse.jetty.http.QuotedCSVParser;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.util.ArrayTrie;
import wiremock.org.eclipse.jetty.util.HostPort;
import wiremock.org.eclipse.jetty.util.StringUtil;
import wiremock.org.eclipse.jetty.util.Trie;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;

public class ForwardedRequestCustomizer
implements HttpConfiguration.Customizer {
    private static final Logger LOG = Log.getLogger(ForwardedRequestCustomizer.class);
    private HostPortHttpField _forcedHost;
    private String _forwardedHeader = HttpHeader.FORWARDED.toString();
    private String _forwardedHostHeader = HttpHeader.X_FORWARDED_HOST.toString();
    private String _forwardedServerHeader = HttpHeader.X_FORWARDED_SERVER.toString();
    private String _forwardedProtoHeader = HttpHeader.X_FORWARDED_PROTO.toString();
    private String _forwardedForHeader = HttpHeader.X_FORWARDED_FOR.toString();
    private String _forwardedPortHeader = HttpHeader.X_FORWARDED_PORT.toString();
    private String _forwardedHttpsHeader = "X-Proxied-Https";
    private String _forwardedCipherSuiteHeader = "Proxy-auth-cert";
    private String _forwardedSslSessionIdHeader = "Proxy-ssl-id";
    private boolean _proxyAsAuthority = false;
    private boolean _sslIsSecure = true;
    private Trie<MethodHandle> _handles;

    public ForwardedRequestCustomizer() {
        this.updateHandles();
    }

    public boolean getProxyAsAuthority() {
        return this._proxyAsAuthority;
    }

    public void setProxyAsAuthority(boolean proxyAsAuthority) {
        this._proxyAsAuthority = proxyAsAuthority;
    }

    public void setForwardedOnly(boolean rfc7239only) {
        if (rfc7239only) {
            if (this._forwardedHeader == null) {
                this._forwardedHeader = HttpHeader.FORWARDED.toString();
            }
            this._forwardedHostHeader = null;
            this._forwardedServerHeader = null;
            this._forwardedForHeader = null;
            this._forwardedPortHeader = null;
            this._forwardedProtoHeader = null;
            this._forwardedHttpsHeader = null;
        } else {
            if (this._forwardedHostHeader == null) {
                this._forwardedHostHeader = HttpHeader.X_FORWARDED_HOST.toString();
            }
            if (this._forwardedServerHeader == null) {
                this._forwardedServerHeader = HttpHeader.X_FORWARDED_SERVER.toString();
            }
            if (this._forwardedForHeader == null) {
                this._forwardedForHeader = HttpHeader.X_FORWARDED_FOR.toString();
            }
            if (this._forwardedPortHeader == null) {
                this._forwardedPortHeader = HttpHeader.X_FORWARDED_PORT.toString();
            }
            if (this._forwardedProtoHeader == null) {
                this._forwardedProtoHeader = HttpHeader.X_FORWARDED_PROTO.toString();
            }
            if (this._forwardedHttpsHeader == null) {
                this._forwardedHttpsHeader = "X-Proxied-Https";
            }
        }
        this.updateHandles();
    }

    public String getForcedHost() {
        return this._forcedHost.getValue();
    }

    public void setForcedHost(String hostAndPort) {
        this._forcedHost = new HostPortHttpField(new ForcedHostPort(hostAndPort));
    }

    public String getForwardedHeader() {
        return this._forwardedHeader;
    }

    public void setForwardedHeader(String forwardedHeader) {
        if (this._forwardedHeader == null || !this._forwardedHeader.equals(forwardedHeader)) {
            this._forwardedHeader = forwardedHeader;
            this.updateHandles();
        }
    }

    public String getForwardedHostHeader() {
        return this._forwardedHostHeader;
    }

    public void setForwardedHostHeader(String forwardedHostHeader) {
        if (this._forwardedHostHeader == null || !this._forwardedHostHeader.equalsIgnoreCase(forwardedHostHeader)) {
            this._forwardedHostHeader = forwardedHostHeader;
            this.updateHandles();
        }
    }

    public String getForwardedServerHeader() {
        return this._forwardedServerHeader;
    }

    public void setForwardedServerHeader(String forwardedServerHeader) {
        if (this._forwardedServerHeader == null || !this._forwardedServerHeader.equalsIgnoreCase(forwardedServerHeader)) {
            this._forwardedServerHeader = forwardedServerHeader;
            this.updateHandles();
        }
    }

    public String getForwardedForHeader() {
        return this._forwardedForHeader;
    }

    public void setForwardedForHeader(String forwardedRemoteAddressHeader) {
        if (this._forwardedForHeader == null || !this._forwardedForHeader.equalsIgnoreCase(forwardedRemoteAddressHeader)) {
            this._forwardedForHeader = forwardedRemoteAddressHeader;
            this.updateHandles();
        }
    }

    public String getForwardedPortHeader() {
        return this._forwardedHostHeader;
    }

    public void setForwardedPortHeader(String forwardedPortHeader) {
        if (this._forwardedHostHeader == null || !this._forwardedHostHeader.equalsIgnoreCase(forwardedPortHeader)) {
            this._forwardedHostHeader = forwardedPortHeader;
            this.updateHandles();
        }
    }

    public String getForwardedProtoHeader() {
        return this._forwardedProtoHeader;
    }

    public void setForwardedProtoHeader(String forwardedProtoHeader) {
        if (this._forwardedProtoHeader == null || !this._forwardedProtoHeader.equalsIgnoreCase(forwardedProtoHeader)) {
            this._forwardedProtoHeader = forwardedProtoHeader;
            this.updateHandles();
        }
    }

    public String getForwardedCipherSuiteHeader() {
        return this._forwardedCipherSuiteHeader;
    }

    public void setForwardedCipherSuiteHeader(String forwardedCipherSuiteHeader) {
        if (this._forwardedCipherSuiteHeader == null || !this._forwardedCipherSuiteHeader.equalsIgnoreCase(forwardedCipherSuiteHeader)) {
            this._forwardedCipherSuiteHeader = forwardedCipherSuiteHeader;
            this.updateHandles();
        }
    }

    public String getForwardedSslSessionIdHeader() {
        return this._forwardedSslSessionIdHeader;
    }

    public void setForwardedSslSessionIdHeader(String forwardedSslSessionIdHeader) {
        if (this._forwardedSslSessionIdHeader == null || !this._forwardedSslSessionIdHeader.equalsIgnoreCase(forwardedSslSessionIdHeader)) {
            this._forwardedSslSessionIdHeader = forwardedSslSessionIdHeader;
            this.updateHandles();
        }
    }

    public String getForwardedHttpsHeader() {
        return this._forwardedHttpsHeader;
    }

    public void setForwardedHttpsHeader(String forwardedHttpsHeader) {
        if (this._forwardedHttpsHeader == null || !this._forwardedHttpsHeader.equalsIgnoreCase(forwardedHttpsHeader)) {
            this._forwardedHttpsHeader = forwardedHttpsHeader;
            this.updateHandles();
        }
    }

    public boolean isSslIsSecure() {
        return this._sslIsSecure;
    }

    public void setSslIsSecure(boolean sslIsSecure) {
        this._sslIsSecure = sslIsSecure;
    }

    @Override
    public void customize(Connector connector, HttpConfiguration config, Request request) {
        HttpFields httpFields = request.getHttpFields();
        Forwarded forwarded = new Forwarded(request, config);
        try {
            for (HttpField field : httpFields) {
                MethodHandle handle = this._handles.get(field.getName());
                if (handle == null) continue;
                handle.invoke(forwarded, field);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (forwarded._proto != null) {
            request.setScheme(forwarded._proto);
            if (forwarded._proto.equalsIgnoreCase(config.getSecureScheme())) {
                request.setSecure(true);
            }
        }
        if (forwarded._host != null) {
            httpFields.put(new HostPortHttpField(forwarded._host));
            request.setAuthority(forwarded._host.getHost(), forwarded._host.getPort());
        }
        if (forwarded._for != null) {
            int port = forwarded._for.getPort() > 0 ? forwarded._for.getPort() : request.getRemotePort();
            request.setRemoteAddr(InetSocketAddress.createUnresolved(forwarded._for.getHost(), port));
        }
    }

    protected String getLeftMost(String headerValue) {
        if (headerValue == null) {
            return null;
        }
        int commaIndex = headerValue.indexOf(44);
        if (commaIndex == -1) {
            return headerValue;
        }
        return headerValue.substring(0, commaIndex).trim();
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    @Deprecated
    public String getHostHeader() {
        return this._forcedHost.getValue();
    }

    @Deprecated
    public void setHostHeader(String hostHeader) {
        this._forcedHost = new HostPortHttpField(hostHeader);
    }

    private void updateHandles() {
        int size = 0;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType type = MethodType.methodType(Void.TYPE, HttpField.class);
        try {
            while (true) {
                this._handles = new ArrayTrie<MethodHandle>(size += 128);
                if (this._forwardedCipherSuiteHeader != null && !this._handles.put(this._forwardedCipherSuiteHeader, lookup.findVirtual(Forwarded.class, "handleCipherSuite", type)) || this._forwardedSslSessionIdHeader != null && !this._handles.put(this._forwardedSslSessionIdHeader, lookup.findVirtual(Forwarded.class, "handleSslSessionId", type)) || this._forwardedHeader != null && !this._handles.put(this._forwardedHeader, lookup.findVirtual(Forwarded.class, "handleRFC7239", type)) || this._forwardedForHeader != null && !this._handles.put(this._forwardedForHeader, lookup.findVirtual(Forwarded.class, "handleFor", type)) || this._forwardedPortHeader != null && !this._handles.put(this._forwardedPortHeader, lookup.findVirtual(Forwarded.class, "handlePort", type)) || this._forwardedHostHeader != null && !this._handles.put(this._forwardedHostHeader, lookup.findVirtual(Forwarded.class, "handleHost", type)) || this._forwardedProtoHeader != null && !this._handles.put(this._forwardedProtoHeader, lookup.findVirtual(Forwarded.class, "handleProto", type)) || this._forwardedHttpsHeader != null && !this._handles.put(this._forwardedHttpsHeader, lookup.findVirtual(Forwarded.class, "handleHttps", type)) || this._forwardedServerHeader != null && !this._handles.put(this._forwardedServerHeader, lookup.findVirtual(Forwarded.class, "handleServer", type))) {
                    continue;
                }
                break;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private class Forwarded
    extends QuotedCSVParser {
        HttpConfiguration _config;
        Request _request;
        boolean _protoRfc7239;
        String _proto;
        HostPort _for;
        HostPort _host;

        public Forwarded(Request request, HttpConfiguration config) {
            super(false);
            this._request = request;
            this._config = config;
            if (ForwardedRequestCustomizer.this._forcedHost != null) {
                this._host = ForwardedRequestCustomizer.this._forcedHost.getHostPort();
            }
        }

        public void handleCipherSuite(HttpField field) {
            this._request.setAttribute("javax.servlet.request.cipher_suite", field.getValue());
            if (ForwardedRequestCustomizer.this.isSslIsSecure()) {
                this._request.setSecure(true);
                this._request.setScheme(this._config.getSecureScheme());
            }
        }

        public void handleSslSessionId(HttpField field) {
            this._request.setAttribute("javax.servlet.request.ssl_session_id", field.getValue());
            if (ForwardedRequestCustomizer.this.isSslIsSecure()) {
                this._request.setSecure(true);
                this._request.setScheme(this._config.getSecureScheme());
            }
        }

        public void handleHost(HttpField field) {
            if (this._host == null) {
                this._host = new XHostPort(ForwardedRequestCustomizer.this.getLeftMost(field.getValue()));
            }
        }

        public void handleServer(HttpField field) {
            if (ForwardedRequestCustomizer.this._proxyAsAuthority && this._host == null) {
                this._host = new XHostPort(ForwardedRequestCustomizer.this.getLeftMost(field.getValue()));
            }
        }

        public void handleProto(HttpField field) {
            if (this._proto == null) {
                this._proto = ForwardedRequestCustomizer.this.getLeftMost(field.getValue());
            }
        }

        public void handleFor(HttpField field) {
            if (this._for == null) {
                this._for = new XHostPort(ForwardedRequestCustomizer.this.getLeftMost(field.getValue()));
            } else if (this._for instanceof XHostPort && "unknown".equals(this._for.getHost())) {
                this._for = new XHostPort(HostPort.normalizeHost(ForwardedRequestCustomizer.this.getLeftMost(field.getValue())), this._for.getPort());
            }
        }

        public void handlePort(HttpField field) {
            if (this._for == null) {
                this._for = new XHostPort("unknown", field.getIntValue());
            } else if (this._for instanceof XHostPort && this._for.getPort() <= 0) {
                this._for = new XHostPort(HostPort.normalizeHost(this._for.getHost()), field.getIntValue());
            }
        }

        public void handleHttps(HttpField field) {
            if (this._proto == null && ("on".equalsIgnoreCase(field.getValue()) || "true".equalsIgnoreCase(field.getValue()))) {
                this._proto = HttpScheme.HTTPS.asString();
            }
        }

        public void handleRFC7239(HttpField field) {
            this.addValue(field.getValue());
        }

        @Override
        protected void parsedParam(StringBuffer buffer, int valueLength, int paramName, int paramValue) {
            if (valueLength == 0 && paramValue > paramName) {
                String name = StringUtil.asciiToLowerCase(buffer.substring(paramName, paramValue - 1));
                String value = buffer.substring(paramValue);
                switch (name) {
                    case "by": {
                        if (!ForwardedRequestCustomizer.this._proxyAsAuthority || value.startsWith("_") || "unknown".equals(value) || this._host != null && !(this._host instanceof XHostPort)) break;
                        this._host = new Rfc7239HostPort(value);
                        break;
                    }
                    case "for": {
                        if (value.startsWith("_") || "unknown".equals(value) || this._for != null && !(this._for instanceof XHostPort)) break;
                        this._for = new Rfc7239HostPort(value);
                        break;
                    }
                    case "host": {
                        if (value.startsWith("_") || "unknown".equals(value) || this._host != null && !(this._host instanceof XHostPort)) break;
                        this._host = new Rfc7239HostPort(value);
                        break;
                    }
                    case "proto": {
                        if (this._proto != null && this._protoRfc7239) break;
                        this._protoRfc7239 = true;
                        this._proto = value;
                    }
                }
            }
        }
    }

    private static class Rfc7239HostPort
    extends HostPort {
        Rfc7239HostPort(String authority) {
            super(authority);
        }
    }

    private static class XHostPort
    extends HostPort {
        XHostPort(String authority) {
            super(authority);
        }

        XHostPort(String host, int port) {
            super(host, port);
        }
    }

    private static class ForcedHostPort
    extends HostPort {
        ForcedHostPort(String authority) {
            super(authority);
        }
    }
}

