/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars;

import java.util.HashMap;
import java.util.Map;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.internal.text.StringEscapeUtils;
import wiremock.com.github.jknack.handlebars.internal.text.translate.LookupTranslator;

public interface EscapingStrategy {
    public static final EscapingStrategy HTML_ENTITY = new Hbs(new String[][]{{"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}, {"'", "&#x27;"}, {"`", "&#x60;"}, {"&", "&amp;"}, {"=", "&#x3D;"}});
    public static final EscapingStrategy HBS3 = new Hbs(new String[][]{{"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}, {"'", "&#x27;"}, {"`", "&#x60;"}, {"&", "&amp;"}});
    public static final EscapingStrategy HBS4 = HTML_ENTITY;
    public static final EscapingStrategy CSV = value -> value == null ? null : StringEscapeUtils.escapeCsv(value.toString());
    public static final EscapingStrategy XML = value -> value == null ? null : StringEscapeUtils.escapeXml11(value.toString());
    public static final EscapingStrategy JS = value -> value == null ? null : StringEscapeUtils.escapeEcmaScript(value.toString());
    public static final EscapingStrategy NOOP = value -> value;
    public static final EscapingStrategy DEF = HBS4;

    public CharSequence escape(CharSequence var1);

    public static class Hbs
    implements EscapingStrategy {
        private static final String EMPTY = "";
        private final LookupTranslator translator;

        public Hbs(String[][] escapeMap) {
            this(Hbs.escapeMap(escapeMap));
        }

        public Hbs(Map<CharSequence, CharSequence> escapeMap) {
            this.translator = new LookupTranslator(escapeMap);
        }

        @Override
        public CharSequence escape(CharSequence value) {
            if (value instanceof Handlebars.SafeString) {
                return ((Handlebars.SafeString)value).content;
            }
            return value == null || value.length() == 0 ? EMPTY : this.translator.translate(value);
        }

        private static Map<CharSequence, CharSequence> escapeMap(String[][] table) {
            HashMap<CharSequence, CharSequence> result = new HashMap<CharSequence, CharSequence>();
            for (String[] row : table) {
                result.put(row[0], row[1]);
            }
            return result;
        }
    }
}

