/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import java.util.Collection;
import wiremock.com.fasterxml.jackson.core.JsonGenerator;
import wiremock.com.fasterxml.jackson.core.JsonToken;
import wiremock.com.fasterxml.jackson.core.type.WritableTypeId;
import wiremock.com.fasterxml.jackson.databind.BeanProperty;
import wiremock.com.fasterxml.jackson.databind.JsonMappingException;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.JsonSerializer;
import wiremock.com.fasterxml.jackson.databind.SerializationFeature;
import wiremock.com.fasterxml.jackson.databind.SerializerProvider;
import wiremock.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import wiremock.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import wiremock.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import wiremock.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import wiremock.com.fasterxml.jackson.databind.ser.std.StaticListSerializerBase;

@JacksonStdImpl
public class StringCollectionSerializer
extends StaticListSerializerBase<Collection<String>> {
    public static final StringCollectionSerializer instance = new StringCollectionSerializer();

    protected StringCollectionSerializer() {
        super(Collection.class);
    }

    protected StringCollectionSerializer(StringCollectionSerializer src, Boolean unwrapSingle) {
        super(src, unwrapSingle);
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
        return new StringCollectionSerializer(this, unwrapSingle);
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor visitor) throws JsonMappingException {
        visitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public void serialize(Collection<String> value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        g2.setCurrentValue(value);
        int len = value.size();
        if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value, g2, provider);
            return;
        }
        g2.writeStartArray(len);
        this.serializeContents(value, g2, provider);
        g2.writeEndArray();
    }

    @Override
    public void serializeWithType(Collection<String> value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g2.setCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.START_ARRAY));
        this.serializeContents(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    private final void serializeContents(Collection<String> value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        int i = 0;
        try {
            for (String str : value) {
                if (str == null) {
                    provider.defaultSerializeNull(g2);
                } else {
                    g2.writeString(str);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, value, i);
        }
    }
}

