/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.upload;

import org.apache.commons.lang3.Validate;

public class ThumbImage {
    private boolean defaultConfig = false;
    private int width;
    private int height;
    private double percent;

    public ThumbImage(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public ThumbImage(double percent) {
        this.percent = percent;
    }

    public ThumbImage() {
        this.defaultConfig = true;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getPercent() {
        return this.percent;
    }

    public boolean isDefaultConfig() {
        return this.defaultConfig;
    }

    public String getPrefixName() {
        if (this.isDefaultConfig()) {
            return this.getPrefixNameBySize();
        }
        if (this.percent != 0.0) {
            return this.getPrefixNameByPercent();
        }
        return this.getPrefixNameBySize();
    }

    private String getPrefixNameBySize() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("_").append(this.width).append("x").append(this.height);
        return new String(buffer);
    }

    private String getPrefixNameByPercent() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("_").append(Math.round(100.0 * this.percent)).append("p_");
        return new String(buffer);
    }

    public String getThumbImagePath(String masterFilename) {
        Validate.notBlank((CharSequence)masterFilename, (String)"\u4e3b\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StringBuilder buff = new StringBuilder(masterFilename);
        int index = buff.lastIndexOf(".");
        buff.insert(index, this.getPrefixName());
        return new String(buff);
    }

    public void setDefaultSize(int width, int height) {
        this.width = width;
        this.height = height;
    }
}

