/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain;

import java.net.InetSocketAddress;

public class TrackerAddressHolder {
    private InetSocketAddress address;
    private boolean available;
    private long lastUnavailableTime;

    public TrackerAddressHolder(InetSocketAddress address) {
        this.address = address;
        this.available = true;
    }

    public void setActive() {
        this.available = true;
    }

    public void setInActive() {
        this.available = false;
        this.lastUnavailableTime = System.currentTimeMillis();
    }

    public boolean isAvailable() {
        return this.available;
    }

    public long getLastUnavailableTime() {
        return this.lastUnavailableTime;
    }

    public boolean canTryToConnect(int retryAfterSecend) {
        if (this.available) {
            return true;
        }
        return System.currentTimeMillis() - this.lastUnavailableTime > (long)(retryAfterSecend * 1000);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }
}

