/*
 * Decompiled with CFR 0.152.
 */
package toan.android.floatingactionmenu;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.widget.ImageButton;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import toan.android.floatingactionmenu.R;

public class FloatingActionButton
extends ImageButton {
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_MINI = 1;
    int mColorNormal;
    int mColorPressed;
    int mColorDisabled;
    String mTitle;
    @DrawableRes
    private int mIcon;
    private Drawable mIconDrawable;
    private int mSize;
    private float mCircleSize;
    private float mShadowRadius;
    private float mShadowOffset;
    private int mDrawableSize;
    boolean mStrokeVisible;

    public FloatingActionButton(Context context) {
        this(context, null);
    }

    public FloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FloatingActionButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    void init(Context context, AttributeSet attributeSet) {
        TypedArray attr2 = context.obtainStyledAttributes(attributeSet, R.styleable.FloatingActionButton, 0, 0);
        this.mColorNormal = attr2.getColor(R.styleable.FloatingActionButton_fab_colorNormal, this.getColor(R.color.default_normal));
        this.mColorPressed = attr2.getColor(R.styleable.FloatingActionButton_fab_colorPressed, this.getColor(R.color.default_pressed));
        this.mColorDisabled = attr2.getColor(R.styleable.FloatingActionButton_fab_colorDisabled, this.getColor(R.color.default_disabled));
        this.mSize = attr2.getInt(R.styleable.FloatingActionButton_fab_size, 0);
        this.mIcon = attr2.getResourceId(R.styleable.FloatingActionButton_fab_icon, 0);
        this.mTitle = attr2.getString(R.styleable.FloatingActionButton_fab_title);
        this.mStrokeVisible = attr2.getBoolean(R.styleable.FloatingActionButton_fab_stroke_visible, true);
        attr2.recycle();
        this.updateCircleSize();
        this.mShadowRadius = this.getDimension(R.dimen.fab_shadow_radius);
        this.mShadowOffset = this.getDimension(R.dimen.fab_shadow_offset);
        this.updateDrawableSize();
        this.updateBackground();
    }

    private void updateDrawableSize() {
        this.mDrawableSize = (int)(this.mCircleSize + 2.0f * this.mShadowRadius);
    }

    private void updateCircleSize() {
        this.mCircleSize = this.getDimension(this.mSize == 0 ? R.dimen.fab_size_normal : R.dimen.fab_size_mini);
    }

    public void setSize(int size) {
        if (size != 1 && size != 0) {
            throw new IllegalArgumentException("Use @FAB_SIZE constants only!");
        }
        if (this.mSize != size) {
            this.mSize = size;
            this.updateCircleSize();
            this.updateDrawableSize();
            this.updateBackground();
        }
    }

    public int getSize() {
        return this.mSize;
    }

    public void setIcon(@DrawableRes int icon) {
        if (this.mIcon != icon) {
            this.mIcon = icon;
            this.mIconDrawable = null;
            this.updateBackground();
        }
    }

    public void setIconDrawable(@NonNull Drawable iconDrawable) {
        if (this.mIconDrawable != iconDrawable) {
            this.mIcon = 0;
            this.mIconDrawable = iconDrawable;
            this.updateBackground();
        }
    }

    public int getColorNormal() {
        return this.mColorNormal;
    }

    public void setColorNormalResId(@ColorRes int colorNormal) {
        this.setColorNormal(this.getColor(colorNormal));
    }

    public void setColorNormal(int color2) {
        if (this.mColorNormal != color2) {
            this.mColorNormal = color2;
            this.updateBackground();
        }
    }

    public int getColorPressed() {
        return this.mColorPressed;
    }

    public void setColorPressedResId(@ColorRes int colorPressed) {
        this.setColorPressed(this.getColor(colorPressed));
    }

    public void setColorPressed(int color2) {
        if (this.mColorPressed != color2) {
            this.mColorPressed = color2;
            this.updateBackground();
        }
    }

    public int getColorDisabled() {
        return this.mColorDisabled;
    }

    public void setColorDisabledResId(@ColorRes int colorDisabled) {
        this.setColorDisabled(this.getColor(colorDisabled));
    }

    public void setColorDisabled(int color2) {
        if (this.mColorDisabled != color2) {
            this.mColorDisabled = color2;
            this.updateBackground();
        }
    }

    public void setStrokeVisible(boolean visible) {
        if (this.mStrokeVisible != visible) {
            this.mStrokeVisible = visible;
            this.updateBackground();
        }
    }

    public boolean isStrokeVisible() {
        return this.mStrokeVisible;
    }

    int getColor(@ColorRes int id2) {
        return this.getResources().getColor(id2);
    }

    float getDimension(@DimenRes int id2) {
        return this.getResources().getDimension(id2);
    }

    public void setTitle(String title) {
        this.mTitle = title;
        TextView label = this.getLabelView();
        if (label != null) {
            label.setText((CharSequence)title);
        }
    }

    TextView getLabelView() {
        return (TextView)this.getTag(R.id.fab_label);
    }

    public String getTitle() {
        return this.mTitle;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.mDrawableSize, this.mDrawableSize);
    }

    void updateBackground() {
        float strokeWidth = this.getDimension(R.dimen.fab_stroke_width);
        float halfStrokeWidth = strokeWidth / 2.0f;
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.getResources().getDrawable(this.mSize == 0 ? R.drawable.fab_bg_normal : R.drawable.fab_bg_mini), this.createFillDrawable(strokeWidth), this.createOuterStrokeDrawable(strokeWidth), this.getIconDrawable()});
        int iconOffset = (int)(this.mCircleSize - this.getDimension(R.dimen.fab_icon_size)) / 2;
        int circleInsetHorizontal = (int)this.mShadowRadius;
        int circleInsetTop = (int)(this.mShadowRadius - this.mShadowOffset);
        int circleInsetBottom = (int)(this.mShadowRadius + this.mShadowOffset);
        layerDrawable.setLayerInset(1, circleInsetHorizontal, circleInsetTop, circleInsetHorizontal, circleInsetBottom);
        layerDrawable.setLayerInset(2, (int)((float)circleInsetHorizontal - halfStrokeWidth), (int)((float)circleInsetTop - halfStrokeWidth), (int)((float)circleInsetHorizontal - halfStrokeWidth), (int)((float)circleInsetBottom - halfStrokeWidth));
        layerDrawable.setLayerInset(3, circleInsetHorizontal + iconOffset, circleInsetTop + iconOffset, circleInsetHorizontal + iconOffset, circleInsetBottom + iconOffset);
        this.setBackgroundCompat((Drawable)layerDrawable);
    }

    Drawable getIconDrawable() {
        if (this.mIconDrawable != null) {
            return this.mIconDrawable;
        }
        if (this.mIcon != 0) {
            return this.getResources().getDrawable(this.mIcon);
        }
        return new ColorDrawable(0);
    }

    private StateListDrawable createFillDrawable(float strokeWidth) {
        StateListDrawable drawable2 = new StateListDrawable();
        drawable2.addState(new int[]{-16842910}, this.createCircleDrawable(this.mColorDisabled, strokeWidth));
        drawable2.addState(new int[]{16842919}, this.createCircleDrawable(this.mColorPressed, strokeWidth));
        drawable2.addState(new int[0], this.createCircleDrawable(this.mColorNormal, strokeWidth));
        return drawable2;
    }

    private Drawable createCircleDrawable(int color2, float strokeWidth) {
        int alpha = Color.alpha((int)color2);
        int opaqueColor = this.opaque(color2);
        ShapeDrawable fillDrawable = new ShapeDrawable((Shape)new OvalShape());
        Paint paint = fillDrawable.getPaint();
        paint.setAntiAlias(true);
        paint.setColor(opaqueColor);
        Drawable[] layers = new Drawable[]{fillDrawable, this.createInnerStrokesDrawable(opaqueColor, strokeWidth)};
        LayerDrawable drawable2 = alpha == 255 || !this.mStrokeVisible ? new LayerDrawable(layers) : new TranslucentLayerDrawable(alpha, layers);
        int halfStrokeWidth = (int)(strokeWidth / 2.0f);
        drawable2.setLayerInset(1, halfStrokeWidth, halfStrokeWidth, halfStrokeWidth, halfStrokeWidth);
        return drawable2;
    }

    private Drawable createOuterStrokeDrawable(float strokeWidth) {
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new OvalShape());
        Paint paint = shapeDrawable.getPaint();
        paint.setAntiAlias(true);
        paint.setStrokeWidth(strokeWidth);
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(-16777216);
        paint.setAlpha(this.opacityToAlpha(0.02f));
        return shapeDrawable;
    }

    private int opacityToAlpha(float opacity) {
        return (int)(255.0f * opacity);
    }

    private int darkenColor(int argb) {
        return this.adjustColorBrightness(argb, 0.9f);
    }

    private int lightenColor(int argb) {
        return this.adjustColorBrightness(argb, 1.1f);
    }

    private int adjustColorBrightness(int argb, float factor) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)argb, (float[])hsv);
        hsv[2] = Math.min(hsv[2] * factor, 1.0f);
        return Color.HSVToColor((int)Color.alpha((int)argb), (float[])hsv);
    }

    private int halfTransparent(int argb) {
        return Color.argb((int)(Color.alpha((int)argb) / 2), (int)Color.red((int)argb), (int)Color.green((int)argb), (int)Color.blue((int)argb));
    }

    private int opaque(int argb) {
        return Color.rgb((int)Color.red((int)argb), (int)Color.green((int)argb), (int)Color.blue((int)argb));
    }

    private Drawable createInnerStrokesDrawable(final int color2, float strokeWidth) {
        if (!this.mStrokeVisible) {
            return new ColorDrawable(0);
        }
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new OvalShape());
        final int bottomStrokeColor = this.darkenColor(color2);
        final int bottomStrokeColorHalfTransparent = this.halfTransparent(bottomStrokeColor);
        final int topStrokeColor = this.lightenColor(color2);
        final int topStrokeColorHalfTransparent = this.halfTransparent(topStrokeColor);
        Paint paint = shapeDrawable.getPaint();
        paint.setAntiAlias(true);
        paint.setStrokeWidth(strokeWidth);
        paint.setStyle(Paint.Style.STROKE);
        shapeDrawable.setShaderFactory(new ShapeDrawable.ShaderFactory(){

            public Shader resize(int width, int height) {
                return new LinearGradient((float)(width / 2), 0.0f, (float)(width / 2), (float)height, new int[]{topStrokeColor, topStrokeColorHalfTransparent, color2, bottomStrokeColorHalfTransparent, bottomStrokeColor}, new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f}, Shader.TileMode.CLAMP);
            }
        });
        return shapeDrawable;
    }

    @SuppressLint(value={"NewApi"})
    private void setBackgroundCompat(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    public void setVisibility(int visibility) {
        TextView label = this.getLabelView();
        if (label != null) {
            label.setVisibility(visibility);
        }
        super.setVisibility(visibility);
    }

    private static class TranslucentLayerDrawable
    extends LayerDrawable {
        private final int mAlpha;

        public TranslucentLayerDrawable(int alpha, Drawable ... layers) {
            super(layers);
            this.mAlpha = alpha;
        }

        public void draw(Canvas canvas) {
            Rect bounds = this.getBounds();
            canvas.saveLayerAlpha((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mAlpha, 31);
            super.draw(canvas);
            canvas.restore();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FAB_SIZE {
    }
}

