/*
 * Decompiled with CFR 0.152.
 */
package com.github.tntkhang.keystore_secure;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.security.auth.x500.X500Principal;
import khangtran.preferenceshelper.PrefHelper;

public class KeystoreSecure {
    private static KeystoreSecure instance;
    private Context mContext;
    private static final boolean IS_M;
    private static final String ANDROID_KEY_STORE = "AndroidKeyStore";
    private static final String RSA_MODE = "RSA/ECB/PKCS1Padding";
    private KeyStore keyStore;

    public static KeystoreSecure initHelper(Context context) {
        if (instance == null) {
            instance = new KeystoreSecure(context);
        }
        return instance;
    }

    private KeystoreSecure(Context context) {
        this.mContext = context;
        PrefHelper.initHelper((Context)context);
    }

    public void encypt(String key, String value) {
        try {
            this.keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
            this.keyStore.load(null);
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", ANDROID_KEY_STORE);
            if (IS_M) {
                KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(key, 3).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"PKCS1Padding"}).setRandomizedEncryptionRequired(false).build();
                kpg.initialize((AlgorithmParameterSpec)spec);
            } else {
                Calendar start = Calendar.getInstance();
                Calendar end = Calendar.getInstance();
                end.add(1, 30);
                KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(this.mContext).setAlias(key).setSubject(new X500Principal("CN=" + key)).setSerialNumber(BigInteger.TEN).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
                kpg.initialize((AlgorithmParameterSpec)spec);
            }
            kpg.generateKeyPair();
            this.save(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String decypt(String key) {
        return this.get(key);
    }

    private String get(String key) {
        String encryptedKeyB64 = PrefHelper.getStringVal((String)key, null);
        byte[] byteKey = new byte[64];
        try {
            byte[] encryptedKey = Base64.decode((String)encryptedKeyB64, (int)0);
            byteKey = this.rsaDecrypt(encryptedKey, key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String(byteKey);
    }

    private void save(String key, String value) {
        try {
            byte[] secureByte = value.getBytes();
            byte[] byteKey = this.rsaEncrypt(secureByte, key);
            String encryptedKey = Base64.encodeToString((byte[])byteKey, (int)0);
            PrefHelper.setVal((String)key, (String)encryptedKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] rsaEncrypt(byte[] secret, String key) throws Exception {
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(key, null);
        Cipher inputCipher = Cipher.getInstance(RSA_MODE);
        inputCipher.init(1, privateKeyEntry.getCertificate().getPublicKey());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, inputCipher);
        cipherOutputStream.write(secret);
        cipherOutputStream.close();
        return outputStream.toByteArray();
    }

    private byte[] rsaDecrypt(byte[] encrypted, String key) throws Exception {
        int nextByte;
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(key, null);
        Cipher output = Cipher.getInstance(RSA_MODE);
        output.init(2, privateKeyEntry.getPrivateKey());
        CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(encrypted), output);
        ArrayList<Byte> values = new ArrayList<Byte>();
        while ((nextByte = cipherInputStream.read()) != -1) {
            values.add((byte)nextByte);
        }
        byte[] bytes = new byte[values.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (Byte)values.get(i);
        }
        return bytes;
    }

    static {
        IS_M = Build.VERSION.SDK_INT >= 23;
    }
}

