/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseMethodHandleReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference.DexBackedFieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.Reference;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;

public class DexBackedMethodHandleReference
extends BaseMethodHandleReference {
    public final DexBackedDexFile dexFile;
    public final int methodHandleIndex;
    public final int methodHandleOffset;

    public DexBackedMethodHandleReference(DexBackedDexFile dexBackedDexFile, int n) {
        this.dexFile = dexBackedDexFile;
        this.methodHandleIndex = n;
        this.methodHandleOffset = dexBackedDexFile.getMethodHandleSection().getOffset(n);
    }

    @Override
    public int getMethodHandleType() {
        return this.dexFile.getBuffer().readUshort(this.methodHandleOffset + 0);
    }

    @Override
    public Reference getMemberReference() {
        int n = this.dexFile.getBuffer().readUshort(this.methodHandleOffset + 4);
        switch (this.getMethodHandleType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new DexBackedFieldReference(this.dexFile, n);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new DexBackedMethodReference(this.dexFile, n);
            }
        }
        throw new ExceptionWithContext("Invalid method handle type: %d", this.getMethodHandleType());
    }
}

