/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicate;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.analysis.reflection.util.ReflectionUtils;
import java.util.HashSet;
import java.util.Set;

final class DexNameFilter
implements Predicate<String> {
    private static final String[] INCLUDED_DEX_NAME_PREFIXES = new String[]{"Landroid/databinding/generated/", "Landroidx/databinding/generated/"};
    private static final String[] INCLUDED_DEX_NAMES = new String[]{"Landroid/databinding/DataBinderMapper;", "Landroid/databinding/DataBinderMapperImpl;", "Landroid/databinding/DataBindingComponent;", "Landroid/databinding/DataBindingUtil;", "Landroid/databinding/MergedDataBinderMapper;", "Landroid/databinding/ViewDataBinding;", "Landroid/databinding/ViewStubProxy;", "Landroid/databinding/adapter/ViewStubBindingAdapter;", "Landroid/databinding/library/baseAdapters/DataBinderMapperImpl;", "Landroidx/databinding/DataBinderMapper;", "Landroidx/databinding/DataBinderMapperImpl;", "Landroidx/databinding/DataBindingComponent;", "Landroidx/databinding/DataBindingUtil;", "Landroidx/databinding/MergedDataBinderMapper;", "Landroidx/databinding/ViewDataBinding;", "Landroidx/databinding/ViewStubProxy;", "Landroidx/databinding/adapter/ViewStubBindingAdapter;", "Landroidx/databinding/library/baseAdapters/DataBinderMapperImpl;"};
    private final String includedDexNamePrefix;
    private final Set<String> excludedDexNames;

    DexNameFilter(String rootPackage, Class ... excludedClasses) {
        String packagePrefix;
        this.includedDexNamePrefix = packagePrefix = 'L' + rootPackage.replace('.', '/') + '/';
        HashSet<String> dexNames = new HashSet<String>();
        for (Class c : excludedClasses) {
            String dexName = ReflectionUtils.javaToDexName((String)c.getName());
            if (!dexName.startsWith(packagePrefix)) continue;
            dexNames.add(dexName);
        }
        this.excludedDexNames = dexNames;
    }

    public boolean apply(String dexName) {
        for (String pkg : INCLUDED_DEX_NAME_PREFIXES) {
            if (!dexName.startsWith(pkg)) continue;
            return true;
        }
        for (String cls : INCLUDED_DEX_NAMES) {
            if (!dexName.equals(cls)) continue;
            return true;
        }
        return dexName.startsWith(this.includedDexNamePrefix) && !dexName.endsWith("/BR;") && !dexName.endsWith("/BuildConfig;") && !dexName.endsWith("/R;") && !dexName.contains("/R$") && !this.excludedDexNames.contains(dexName);
    }
}

