/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.io;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.math.IntMath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;

public final class ByteStreams {
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int n) {
        }

        @Override
        public void write(byte[] byArray) {
            Preconditions.checkNotNull(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            Preconditions.checkNotNull(byArray);
        }

        public String toString() {
            return "ByteStreams.nullOutputStream()";
        }
    };

    private ByteStreams() {
    }

    private static byte[] toByteArrayInternal(InputStream inputStream, Deque<byte[]> deque, int n) throws IOException {
        int n2 = 8192;
        while (n < 0x7FFFFFF7) {
            byte[] byArray = new byte[Math.min(n2, 0x7FFFFFF7 - n)];
            deque.add(byArray);
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4 = inputStream.read(byArray, n3, byArray.length - n3);
                if (n4 == -1) {
                    return ByteStreams.combineBuffers(deque, n);
                }
                n3 += n4;
                n += n4;
            }
            n2 = IntMath.saturatedMultiply(n2, 2);
        }
        if (inputStream.read() == -1) {
            return ByteStreams.combineBuffers(deque, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError("input is too large to fit in a byte array");
    }

    private static byte[] combineBuffers(Deque<byte[]> deque, int n) {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = n; i > 0; i -= n2) {
            byte[] byArray2 = deque.removeFirst();
            n2 = Math.min(i, byArray2.length);
            int n3 = n - i;
            System.arraycopy(byArray2, 0, byArray, n3, n2);
        }
        return byArray;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        Preconditions.checkNotNull(inputStream);
        return ByteStreams.toByteArrayInternal(inputStream, new ArrayDeque<byte[]>(20), 0);
    }
}

