/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.value.DexBackedEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;

public abstract class EncodedArrayItemIterator {
    public static final EncodedArrayItemIterator EMPTY = new EncodedArrayItemIterator(){

        @Override
        public EncodedValue getNextOrNull() {
            return null;
        }

        @Override
        public void skipNext() {
        }

        @Override
        public int getReaderOffset() {
            return 0;
        }

        @Override
        public int getItemCount() {
            return 0;
        }
    };

    public abstract EncodedValue getNextOrNull();

    public abstract void skipNext();

    public abstract int getReaderOffset();

    public abstract int getItemCount();

    public static EncodedArrayItemIterator newOrEmpty(DexBackedDexFile dexBackedDexFile, int n) {
        if (n == 0) {
            return EMPTY;
        }
        return new EncodedArrayItemIteratorImpl(dexBackedDexFile, n);
    }

    private static class EncodedArrayItemIteratorImpl
    extends EncodedArrayItemIterator {
        private final DexReader reader;
        private final DexBackedDexFile dexFile;
        private final int size;
        private int index = 0;

        public EncodedArrayItemIteratorImpl(DexBackedDexFile dexBackedDexFile, int n) {
            this.dexFile = dexBackedDexFile;
            this.reader = dexBackedDexFile.getDataBuffer().readerAt(n);
            this.size = this.reader.readSmallUleb128();
        }

        @Override
        public EncodedValue getNextOrNull() {
            if (this.index < this.size) {
                ++this.index;
                return DexBackedEncodedValue.readFrom(this.dexFile, this.reader);
            }
            return null;
        }

        @Override
        public void skipNext() {
            if (this.index < this.size) {
                ++this.index;
                DexBackedEncodedValue.skipFrom(this.reader);
            }
        }

        @Override
        public int getReaderOffset() {
            return this.reader.getOffset();
        }

        @Override
        public int getItemCount() {
            return this.size;
        }
    }
}

