/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.VerificationError;

public class Preconditions {
    public static void checkFormat(Opcode opcode, Format format) {
        if (opcode.format != format) {
            throw new IllegalArgumentException(String.format("Invalid opcode %s for %s", opcode.name, format.name()));
        }
    }

    public static int checkNibbleRegister(int n) {
        if ((n & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(String.format("Invalid register: v%d. Must be between v0 and v15, inclusive.", n));
        }
        return n;
    }

    public static int checkByteRegister(int n) {
        if ((n & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException(String.format("Invalid register: v%d. Must be between v0 and v255, inclusive.", n));
        }
        return n;
    }

    public static int checkShortRegister(int n) {
        if ((n & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException(String.format("Invalid register: v%d. Must be between v0 and v65535, inclusive.", n));
        }
        return n;
    }

    public static int checkNibbleLiteral(int n) {
        if (n < -8 || n > 7) {
            throw new IllegalArgumentException(String.format("Invalid literal value: %d. Must be between -8 and 7, inclusive.", n));
        }
        return n;
    }

    public static int checkByteLiteral(int n) {
        if (n < -128 || n > 127) {
            throw new IllegalArgumentException(String.format("Invalid literal value: %d. Must be between -128 and 127, inclusive.", n));
        }
        return n;
    }

    public static int checkShortLiteral(int n) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Invalid literal value: %d. Must be between -32768 and 32767, inclusive.", n));
        }
        return n;
    }

    public static int checkIntegerHatLiteral(int n) {
        if ((n & 0xFFFF) != 0) {
            throw new IllegalArgumentException(String.format("Invalid literal value: %d. Low 16 bits must be zeroed out.", n));
        }
        return n;
    }

    public static long checkLongHatLiteral(long l) {
        if ((l & 0xFFFFFFFFFFFFL) != 0L) {
            throw new IllegalArgumentException(String.format("Invalid literal value: %d. Low 48 bits must be zeroed out.", l));
        }
        return l;
    }

    public static int check35cAnd45ccRegisterCount(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(String.format("Invalid register count: %d. Must be between 0 and 5, inclusive.", n));
        }
        return n;
    }

    public static int checkRegisterRangeCount(int n) {
        if ((n & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException(String.format("Invalid register count: %d. Must be between 0 and 255, inclusive.", n));
        }
        return n;
    }

    public static void checkValueArg(int n, int n2) {
        if (n > n2) {
            if (n2 == 0) {
                throw new IllegalArgumentException(String.format("Invalid value_arg value %d for an encoded_value. Expecting 0", n));
            }
            throw new IllegalArgumentException(String.format("Invalid value_arg value %d for an encoded_value. Expecting 0..%d, inclusive", n, n2));
        }
    }

    public static int checkVerificationError(int n) {
        if (!VerificationError.isValidVerificationError(n)) {
            throw new IllegalArgumentException(String.format("Invalid verification error value: %d. Must be between 1 and 9, inclusive", n));
        }
        return n;
    }
}

