/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;

public class BaseDexBuffer {
    final byte[] buf;
    final int baseOffset;

    public BaseDexBuffer(byte[] byArray) {
        this(byArray, 0);
    }

    public BaseDexBuffer(byte[] byArray, int n) {
        this.buf = byArray;
        this.baseOffset = n;
    }

    public int readSmallUint(int n) {
        int n2;
        byte[] byArray = this.buf;
        if ((n2 = byArray[n += this.baseOffset] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24) < 0) {
            throw new ExceptionWithContext("Encountered small uint that is out of range at offset 0x%x", n);
        }
        return n2;
    }

    public int readOptionalUint(int n) {
        int n2;
        byte[] byArray = this.buf;
        if ((n2 = byArray[n += this.baseOffset] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24) < -1) {
            throw new ExceptionWithContext("Encountered optional uint that is out of range at offset 0x%x", n);
        }
        return n2;
    }

    public int readUshort(int n) {
        byte[] byArray = this.buf;
        return byArray[n += this.baseOffset] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    public int readUbyte(int n) {
        return this.buf[n + this.baseOffset] & 0xFF;
    }

    public long readLong(int n) {
        byte[] byArray = this.buf;
        return (long)(byArray[n += this.baseOffset] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16) | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | (long)byArray[n + 7] << 56;
    }

    public int readInt(int n) {
        byte[] byArray = this.buf;
        return byArray[n += this.baseOffset] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    public int readShort(int n) {
        byte[] byArray = this.buf;
        return byArray[n += this.baseOffset] & 0xFF | byArray[n + 1] << 8;
    }

    public int readByte(int n) {
        return this.buf[this.baseOffset + n];
    }
}

