/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeSet;
import java.util.List;
import java.util.Set;

public abstract class AnnotationsDirectory {
    public static final AnnotationsDirectory EMPTY = new AnnotationsDirectory(){

        @Override
        public Set<? extends DexBackedAnnotation> getClassAnnotations() {
            return ImmutableSet.of();
        }

        @Override
        public AnnotationIterator getFieldAnnotationIterator() {
            return AnnotationIterator.EMPTY;
        }

        @Override
        public AnnotationIterator getMethodAnnotationIterator() {
            return AnnotationIterator.EMPTY;
        }

        @Override
        public AnnotationIterator getParameterAnnotationIterator() {
            return AnnotationIterator.EMPTY;
        }
    };

    public abstract Set<? extends DexBackedAnnotation> getClassAnnotations();

    public abstract AnnotationIterator getFieldAnnotationIterator();

    public abstract AnnotationIterator getMethodAnnotationIterator();

    public abstract AnnotationIterator getParameterAnnotationIterator();

    public static AnnotationsDirectory newOrEmpty(DexBackedDexFile dexBackedDexFile, int n) {
        if (n == 0) {
            return EMPTY;
        }
        return new AnnotationsDirectoryImpl(dexBackedDexFile, n);
    }

    public static Set<? extends DexBackedAnnotation> getAnnotations(final DexBackedDexFile dexBackedDexFile, final int n) {
        if (n != 0) {
            final int n2 = dexBackedDexFile.readSmallUint(n);
            return new FixedSizeSet<DexBackedAnnotation>(){

                @Override
                public DexBackedAnnotation readItem(int n3) {
                    int n22 = dexBackedDexFile.readSmallUint(n + 4 + 4 * n3);
                    return new DexBackedAnnotation(dexBackedDexFile, n22);
                }

                @Override
                public int size() {
                    return n2;
                }
            };
        }
        return ImmutableSet.of();
    }

    public static List<Set<? extends DexBackedAnnotation>> getParameterAnnotations(final DexBackedDexFile dexBackedDexFile, final int n) {
        if (n > 0) {
            final int n2 = dexBackedDexFile.readSmallUint(n);
            return new FixedSizeList<Set<? extends DexBackedAnnotation>>(){

                @Override
                public Set<? extends DexBackedAnnotation> readItem(int n3) {
                    int n22 = dexBackedDexFile.readSmallUint(n + 4 + n3 * 4);
                    return AnnotationsDirectory.getAnnotations(dexBackedDexFile, n22);
                }

                @Override
                public int size() {
                    return n2;
                }
            };
        }
        return ImmutableList.of();
    }

    private static class AnnotationsDirectoryImpl
    extends AnnotationsDirectory {
        public final DexBackedDexFile dexFile;
        private final int directoryOffset;

        public AnnotationsDirectoryImpl(DexBackedDexFile dexBackedDexFile, int n) {
            this.dexFile = dexBackedDexFile;
            this.directoryOffset = n;
        }

        public int getFieldAnnotationCount() {
            return this.dexFile.readSmallUint(this.directoryOffset + 4);
        }

        public int getMethodAnnotationCount() {
            return this.dexFile.readSmallUint(this.directoryOffset + 8);
        }

        public int getParameterAnnotationCount() {
            return this.dexFile.readSmallUint(this.directoryOffset + 12);
        }

        @Override
        public Set<? extends DexBackedAnnotation> getClassAnnotations() {
            return AnnotationsDirectoryImpl.getAnnotations(this.dexFile, this.dexFile.readSmallUint(this.directoryOffset));
        }

        @Override
        public AnnotationIterator getFieldAnnotationIterator() {
            int n = this.getFieldAnnotationCount();
            if (n == 0) {
                return AnnotationIterator.EMPTY;
            }
            return new AnnotationIteratorImpl(this.directoryOffset + 16, n);
        }

        @Override
        public AnnotationIterator getMethodAnnotationIterator() {
            int n = this.getMethodAnnotationCount();
            if (n == 0) {
                return AnnotationIterator.EMPTY;
            }
            int n2 = this.getFieldAnnotationCount();
            int n3 = this.directoryOffset + 16 + n2 * 8;
            return new AnnotationIteratorImpl(n3, n);
        }

        @Override
        public AnnotationIterator getParameterAnnotationIterator() {
            int n = this.getParameterAnnotationCount();
            if (n == 0) {
                return AnnotationIterator.EMPTY;
            }
            int n2 = this.getFieldAnnotationCount();
            int n3 = this.getMethodAnnotationCount();
            int n4 = this.directoryOffset + 16 + n2 * 8 + n3 * 8;
            return new AnnotationIteratorImpl(n4, n);
        }

        private class AnnotationIteratorImpl
        implements AnnotationIterator {
            private final int startOffset;
            private final int size;
            private int currentIndex;
            private int currentItemIndex;

            public AnnotationIteratorImpl(int n, int n2) {
                this.startOffset = n;
                this.size = n2;
                this.currentItemIndex = AnnotationsDirectoryImpl.this.dexFile.readSmallUint(n);
                this.currentIndex = 0;
            }

            @Override
            public int seekTo(int n) {
                while (this.currentItemIndex < n && this.currentIndex + 1 < this.size) {
                    ++this.currentIndex;
                    this.currentItemIndex = AnnotationsDirectoryImpl.this.dexFile.readSmallUint(this.startOffset + this.currentIndex * 8);
                }
                if (this.currentItemIndex == n) {
                    return AnnotationsDirectoryImpl.this.dexFile.readSmallUint(this.startOffset + this.currentIndex * 8 + 4);
                }
                return 0;
            }
        }
    }

    public static interface AnnotationIterator {
        public static final AnnotationIterator EMPTY = new AnnotationIterator(){

            @Override
            public int seekTo(int n) {
                return 0;
            }
        };

        public int seekTo(int var1);
    }
}

