/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DexDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.FileDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.DexPool;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DexFileGenerator {
    private final File cacheDir;

    DexFileGenerator(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    dalvik.system.DexFile generateDexFile(DexFile dexFile) throws IOException {
        dalvik.system.DexFile file;
        if (!this.cacheDir.isDirectory() && !this.cacheDir.mkdirs()) {
            throw new IOException("Cannot create " + this.cacheDir);
        }
        File dex = File.createTempFile("classes", ".dex", this.cacheDir);
        dex.deleteOnExit();
        String dexPath = dex.getCanonicalPath();
        File tmp = new File(this.cacheDir, dex.getName() + ".tmp.dex");
        String tmpPath = tmp.getCanonicalPath();
        try {
            DexPool.writeTo((DexDataStore)new FileDataStore(tmp), (DexFile)dexFile);
            file = dalvik.system.DexFile.loadDex((String)tmpPath, (String)dexPath, (int)0);
        }
        catch (Throwable throwable) {
            FileUtils.delete(tmp);
            throw throwable;
        }
        FileUtils.delete(tmp);
        Logger logger = Loggers.get();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("DEX file generated: " + dexPath);
        }
        return file;
    }
}

