/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexClassSource;
import com.github.tmurakami.dexopener.DexFileGenerator;
import com.github.tmurakami.dexopener.DexFileHolder;
import com.github.tmurakami.dexopener.DexFileHolderImpl;
import com.github.tmurakami.dexopener.FinalModifierRemoverModule;
import com.github.tmurakami.dexopener.IOUtils;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassFile;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.DexRewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.RewriterModule;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class AndroidClassSource
implements ClassSource {
    private static final int MAX_CLASSES_PER_DEX_FILE = 100;
    private final Opcodes opcodes;
    private final String sourceDir;
    private final ClassNameFilter classNameFilter;
    private final DexFileGenerator dexFileGenerator;
    private final Executor executor;
    private ClassSource delegate;

    AndroidClassSource(Opcodes opcodes, String sourceDir, ClassNameFilter classNameFilter, DexFileGenerator dexFileGenerator, Executor executor) {
        this.opcodes = opcodes;
        this.sourceDir = sourceDir;
        this.classNameFilter = classNameFilter;
        this.dexFileGenerator = dexFileGenerator;
        this.executor = executor;
    }

    public ClassFile getClassFile(@NonNull String className) throws IOException {
        return this.classNameFilter.accept(className) ? this.getDelegate().getClassFile(className) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassSource getDelegate() throws IOException {
        ClassSource source = this.delegate;
        if (source != null) {
            return source;
        }
        HashMap<String, DexFileHolder> holderMap = new HashMap<String, DexFileHolder>();
        try (ZipInputStream in = new ZipInputStream(new FileInputStream(this.sourceDir));){
            this.map(in, holderMap);
        }
        if (holderMap.isEmpty()) {
            throw new IllegalStateException("There are no classes to be opened");
        }
        this.delegate = new DexClassSource(holderMap);
        return this.delegate;
    }

    private void map(ZipInputStream in, Map<String, DexFileHolder> holderMap) throws IOException {
        ZipEntry e;
        Logger logger = Loggers.get();
        HashSet<ClassDef> classesToBeOpened = new HashSet<ClassDef>();
        DexFileHolderImpl holder = new DexFileHolderImpl();
        while ((e = in.getNextEntry()) != null) {
            String name = e.getName();
            if (!name.startsWith("classes") || !name.endsWith(".dex")) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Reading the entry " + name + " from " + this.sourceDir);
            }
            DexBackedDexFile dexFile = new DexBackedDexFile(this.opcodes, IOUtils.readBytes(in));
            for (ClassDef def : dexFile.getClasses()) {
                String dexName = def.getType();
                String className = dexName.substring(1, dexName.length() - 1).replace('/', '.');
                if (!this.classNameFilter.accept(className)) continue;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Class to be opened: " + className);
                }
                classesToBeOpened.add(def);
                holderMap.put(className, holder);
                if (classesToBeOpened.size() < 100) continue;
                holder.setDexFileFuture(this.openClasses(classesToBeOpened));
                classesToBeOpened = new HashSet();
                holder = new DexFileHolderImpl();
            }
        }
        if (!classesToBeOpened.isEmpty()) {
            holder.setDexFileFuture(this.openClasses(classesToBeOpened));
        }
    }

    private RunnableFuture<? extends dalvik.system.DexFile> openClasses(Set<? extends ClassDef> classes) {
        DexFileTask dexFileTask = new DexFileTask(this.opcodes, classes, this.dexFileGenerator);
        FutureTask<dalvik.system.DexFile> future = new FutureTask<dalvik.system.DexFile>(dexFileTask);
        this.executor.execute(future);
        return future;
    }

    private static class DexFileTask
    implements Callable<dalvik.system.DexFile>,
    DexFile {
        private final Opcodes opcodes;
        private Set<? extends ClassDef> classes;
        private final DexFileGenerator dexFileGenerator;

        DexFileTask(Opcodes opcodes, Set<? extends ClassDef> classes, DexFileGenerator dexFileGenerator) {
            this.opcodes = opcodes;
            this.classes = classes;
            this.dexFileGenerator = dexFileGenerator;
        }

        public Opcodes getOpcodes() {
            return this.opcodes;
        }

        public Set<? extends ClassDef> getClasses() {
            return this.classes;
        }

        @Override
        public dalvik.system.DexFile call() throws IOException {
            DexRewriter dexRewriter = new DexRewriter((RewriterModule)new FinalModifierRemoverModule());
            try {
                dalvik.system.DexFile dexFile = this.dexFileGenerator.generateDexFile(dexRewriter.rewriteDexFile((DexFile)this));
                return dexFile;
            }
            finally {
                this.classes = Collections.emptySet();
            }
        }
    }
}

