/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseTypeReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.TypeReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.Rewriter;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RewriterUtils {
    public static <T> T rewriteNullable(Rewriter<T> rewriter, T t) {
        return t == null ? null : (T)rewriter.rewrite(t);
    }

    public static <T> Set<T> rewriteSet(final Rewriter<T> rewriter, final Set<? extends T> set) {
        return new AbstractSet<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = set.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return RewriterUtils.rewriteNullable(rewriter, iterator.next());
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return set.size();
            }
        };
    }

    public static <T> List<T> rewriteList(final Rewriter<T> rewriter, final List<? extends T> list) {
        return new AbstractList<T>(){

            @Override
            public T get(int n) {
                return RewriterUtils.rewriteNullable(rewriter, list.get(n));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static <T> Iterable<T> rewriteIterable(final Rewriter<T> rewriter, final Iterable<? extends T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return RewriterUtils.rewriteNullable(rewriter, iterator.next());
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static TypeReference rewriteTypeReference(final Rewriter<String> rewriter, final TypeReference typeReference) {
        return new BaseTypeReference(){

            @Override
            public String getType() {
                return rewriter.rewrite(typeReference.getType());
            }
        };
    }
}

