/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.BaseDexBuffer;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.raw.HeaderItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.raw.MapItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeSet;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.DexUtil;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.util.List;
import java.util.Set;

public class DexBackedDexFile
extends BaseDexBuffer
implements DexFile {
    private final Opcodes opcodes;
    private final int stringCount;
    private final int stringStartOffset;
    private final int typeCount;
    private final int typeStartOffset;
    private final int protoCount;
    private final int protoStartOffset;
    private final int fieldCount;
    private final int fieldStartOffset;
    private final int methodCount;
    private final int methodStartOffset;
    private final int classCount;
    private final int classStartOffset;
    private final int mapOffset;

    protected DexBackedDexFile(Opcodes opcodes, byte[] byArray, int n, boolean bl) {
        super(byArray, n);
        int n2 = bl ? DexUtil.verifyDexHeader(byArray, n) : HeaderItem.getVersion(byArray, n);
        this.opcodes = opcodes == null ? Opcodes.forDexVersion(n2) : opcodes;
        this.stringCount = this.readSmallUint(56);
        this.stringStartOffset = this.readSmallUint(60);
        this.typeCount = this.readSmallUint(64);
        this.typeStartOffset = this.readSmallUint(68);
        this.protoCount = this.readSmallUint(72);
        this.protoStartOffset = this.readSmallUint(76);
        this.fieldCount = this.readSmallUint(80);
        this.fieldStartOffset = this.readSmallUint(84);
        this.methodCount = this.readSmallUint(88);
        this.methodStartOffset = this.readSmallUint(92);
        this.classCount = this.readSmallUint(96);
        this.classStartOffset = this.readSmallUint(100);
        this.mapOffset = this.readSmallUint(52);
    }

    public DexBackedDexFile(Opcodes opcodes, byte[] byArray) {
        this(opcodes, byArray, 0, true);
    }

    @Override
    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    public Set<? extends DexBackedClassDef> getClasses() {
        return new FixedSizeSet<DexBackedClassDef>(){

            @Override
            public DexBackedClassDef readItem(int n) {
                return new DexBackedClassDef(DexBackedDexFile.this, DexBackedDexFile.this.getClassDefItemOffset(n));
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.classCount;
            }
        };
    }

    public int getStringIdItemOffset(int n) {
        if (n < 0 || n >= this.stringCount) {
            throw new InvalidItemIndex(n, "String index out of bounds: %d", n);
        }
        return this.stringStartOffset + n * 4;
    }

    public int getTypeIdItemOffset(int n) {
        if (n < 0 || n >= this.typeCount) {
            throw new InvalidItemIndex(n, "Type index out of bounds: %d", n);
        }
        return this.typeStartOffset + n * 4;
    }

    public int getFieldIdItemOffset(int n) {
        if (n < 0 || n >= this.fieldCount) {
            throw new InvalidItemIndex(n, "Field index out of bounds: %d", n);
        }
        return this.fieldStartOffset + n * 8;
    }

    public int getMethodIdItemOffset(int n) {
        if (n < 0 || n >= this.methodCount) {
            throw new InvalidItemIndex(n, "Method index out of bounds: %d", n);
        }
        return this.methodStartOffset + n * 8;
    }

    public int getProtoIdItemOffset(int n) {
        if (n < 0 || n >= this.protoCount) {
            throw new InvalidItemIndex(n, "Proto index out of bounds: %d", n);
        }
        return this.protoStartOffset + n * 12;
    }

    public int getClassDefItemOffset(int n) {
        if (n < 0 || n >= this.classCount) {
            throw new InvalidItemIndex(n, "Class index out of bounds: %d", n);
        }
        return this.classStartOffset + n * 32;
    }

    public int getCallSiteIdItemOffset(int n) {
        MapItem mapItem = this.getMapItemForSection(7);
        if (mapItem == null || n >= mapItem.getItemCount()) {
            throw new InvalidItemIndex(n, "Call site index out of bounds: %d", n);
        }
        return mapItem.getOffset() + n * 4;
    }

    public int getMethodHandleItemOffset(int n) {
        MapItem mapItem = this.getMapItemForSection(8);
        if (mapItem == null || n >= mapItem.getItemCount()) {
            throw new InvalidItemIndex(n, "Method handle index out of bounds: %d", n);
        }
        return mapItem.getOffset() + n * 8;
    }

    public String getString(int n) {
        int n2 = this.getStringIdItemOffset(n);
        int n3 = this.readSmallUint(n2);
        DexReader dexReader = this.readerAt(n3);
        int n4 = dexReader.readSmallUleb128();
        return dexReader.readString(n4);
    }

    public String getOptionalString(int n) {
        if (n == -1) {
            return null;
        }
        return this.getString(n);
    }

    public String getType(int n) {
        int n2 = this.getTypeIdItemOffset(n);
        int n3 = this.readSmallUint(n2);
        return this.getString(n3);
    }

    public String getOptionalType(int n) {
        if (n == -1) {
            return null;
        }
        return this.getType(n);
    }

    public DexReader readerAt(int n) {
        return new DexReader(this, n);
    }

    public List<MapItem> getMapItems() {
        final int n = this.readSmallUint(this.mapOffset);
        return new FixedSizeList<MapItem>(){

            @Override
            public MapItem readItem(int n3) {
                int n2 = DexBackedDexFile.this.mapOffset + 4 + n3 * 12;
                return new MapItem(DexBackedDexFile.this, n2);
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    public MapItem getMapItemForSection(int n) {
        for (MapItem mapItem : this.getMapItems()) {
            if (mapItem.getType() != n) continue;
            return mapItem;
        }
        return null;
    }

    public static class InvalidItemIndex
    extends ExceptionWithContext {
        private final int itemIndex;

        public InvalidItemIndex(int n, String string, Object ... objectArray) {
            super(string, objectArray);
            this.itemIndex = n;
        }
    }

    public static class NotADexFile
    extends RuntimeException {
        public NotADexFile() {
        }

        public NotADexFile(String string) {
            super(string);
        }
    }
}

