/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector;

import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassFile;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.Loggers;
import java.io.IOError;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class InjectorClassLoader
extends ClassLoader {
    private final ClassSource source;
    private final ClassLoader injectionTarget;
    private final Set<String> findingClasses = new HashSet<String>();

    InjectorClassLoader(ClassLoader classLoader, ClassSource classSource, ClassLoader classLoader2) {
        super(classLoader);
        this.source = classSource;
        this.injectionTarget = classLoader2;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.injectClass(string);
        return clazz == null ? super.findClass(string) : clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> injectClass(String string) {
        ClassFile classFile;
        if (string.startsWith("com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.")) {
            return null;
        }
        Set<String> set = this.findingClasses;
        if (set.contains(string)) {
            throw new IllegalStateException(string + " is recursively loaded");
        }
        try {
            classFile = this.source.getClassFile(string);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        if (classFile == null) {
            return null;
        }
        set.add(string);
        try {
            Object object;
            Class clazz = classFile.toClass(this.injectionTarget);
            Logger logger = Loggers.get();
            if (logger.isLoggable(Level.FINEST)) {
                object = Integer.toHexString(System.identityHashCode(this.injectionTarget));
                String string2 = this.injectionTarget.getClass().getName() + '@' + (String)object;
                logger.finest("The class " + clazz.getName() + " was injected into " + string2);
            }
            object = clazz;
            return object;
        }
        finally {
            set.remove(string);
        }
    }
}

