/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.FinalModifierRemoverModule;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.DexRewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.RewriterModule;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DexDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.FileDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.DexPool;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ClassOpener {
    private final Executor executor;
    private final File cacheDir;

    ClassOpener(Executor executor, File cacheDir) {
        this.executor = executor;
        this.cacheDir = cacheDir;
    }

    RunnableFuture<? extends dalvik.system.DexFile> openClasses(Opcodes opcodes, Set<? extends ClassDef> classes) {
        OpenDexFile openDexFile = new OpenDexFile(opcodes, classes, this.cacheDir);
        FutureTask<dalvik.system.DexFile> future = new FutureTask<dalvik.system.DexFile>(openDexFile);
        this.executor.execute(future);
        return future;
    }

    private static class OpenDexFile
    implements Callable<dalvik.system.DexFile> {
        private final Opcodes opcodes;
        private Set<? extends ClassDef> classes;
        private final File cacheDir;

        OpenDexFile(Opcodes opcodes, Set<? extends ClassDef> classes, File cacheDir) {
            this.opcodes = opcodes;
            this.classes = classes;
            this.cacheDir = cacheDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public dalvik.system.DexFile call() throws IOException {
            ImmutableDexFile dexFile = new ImmutableDexFile(this.opcodes, this.classes);
            DexRewriter dexRewriter = new DexRewriter((RewriterModule)new FinalModifierRemoverModule());
            try {
                dalvik.system.DexFile dexFile2 = OpenDexFile.generateDexFile(dexRewriter.rewriteDexFile((DexFile)dexFile), this.cacheDir);
                return dexFile2;
            }
            finally {
                this.classes = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static dalvik.system.DexFile generateDexFile(DexFile dexFile, File cacheDir) throws IOException {
            dalvik.system.DexFile file;
            if (!cacheDir.isDirectory() && !cacheDir.mkdirs()) {
                throw new IOException("Cannot create " + cacheDir);
            }
            File dex = File.createTempFile("classes", ".dex", cacheDir);
            dex.deleteOnExit();
            String dexPath = dex.getCanonicalPath();
            File tmp = new File(cacheDir, dex.getName() + ".tmp.dex");
            String tmpPath = tmp.getCanonicalPath();
            try {
                DexPool.writeTo((DexDataStore)new FileDataStore(tmp), (DexFile)dexFile);
                file = dalvik.system.DexFile.loadDex((String)tmpPath, (String)dexPath, (int)0);
            }
            catch (Throwable throwable) {
                FileUtils.delete(tmp);
                throw throwable;
            }
            FileUtils.delete(tmp);
            Logger logger = Loggers.get();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("DEX file generated: " + dexPath);
            }
            return file;
        }
    }
}

