/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

final class ClassNameFilter {
    private static final String[] INCLUDED_PACKAGES = new String[]{"android.databinding.generated."};
    private static final String[] INCLUDED_CLASSES = new String[]{"android.databinding.DataBinderMapper", "android.databinding.DataBindingComponent", "android.databinding.DataBindingUtil"};
    private final String packagePrefix;

    ClassNameFilter(String packagePrefix) {
        this.packagePrefix = packagePrefix;
    }

    boolean accept(String className) {
        for (String pkg : INCLUDED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            return true;
        }
        for (String cls : INCLUDED_CLASSES) {
            if (!className.equals(cls)) continue;
            return true;
        }
        return !className.endsWith(".BR") && !className.endsWith(".BuildConfig") && !className.endsWith(".R") && !className.contains(".R$") && className.startsWith(this.packagePrefix);
    }
}

