/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends InputStream {
    private int filePosition;
    private final RandomAccessFile raf;

    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile, int n) {
        this.filePosition = n;
        this.raf = randomAccessFile;
    }

    @Override
    public int read() throws IOException {
        this.raf.seek(this.filePosition);
        ++this.filePosition;
        return this.raf.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.raf.seek(this.filePosition);
        int n = this.raf.read(byArray);
        this.filePosition += n;
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.raf.seek(this.filePosition);
        int n3 = this.raf.read(byArray, n, n2);
        this.filePosition += n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        int n = Math.min((int)l, this.available());
        this.filePosition += n;
        return n;
    }

    @Override
    public int available() throws IOException {
        return (int)this.raf.length() - this.filePosition;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

