/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction3rms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction3rms
extends ImmutableInstruction
implements Instruction3rms {
    public static final Format FORMAT = Format.Format3rms;
    protected final int startRegister;
    protected final int registerCount;
    protected final int vtableIndex;

    public ImmutableInstruction3rms(Opcode opcode, int n, int n2, int n3) {
        super(opcode);
        this.startRegister = Preconditions.checkShortRegister(n);
        this.registerCount = Preconditions.checkRegisterRangeCount(n2);
        this.vtableIndex = Preconditions.checkVtableIndex(n3);
    }

    public static ImmutableInstruction3rms of(Instruction3rms instruction3rms) {
        if (instruction3rms instanceof ImmutableInstruction3rms) {
            return (ImmutableInstruction3rms)instruction3rms;
        }
        return new ImmutableInstruction3rms(instruction3rms.getOpcode(), instruction3rms.getStartRegister(), instruction3rms.getRegisterCount(), instruction3rms.getVtableIndex());
    }

    @Override
    public int getStartRegister() {
        return this.startRegister;
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    @Override
    public int getVtableIndex() {
        return this.vtableIndex;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

