/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35mi;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction35mi
extends ImmutableInstruction
implements Instruction35mi {
    public static final Format FORMAT = Format.Format35mi;
    protected final int registerCount;
    protected final int registerC;
    protected final int registerD;
    protected final int registerE;
    protected final int registerF;
    protected final int registerG;
    protected final int inlineIndex;

    public ImmutableInstruction35mi(Opcode opcode, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(opcode);
        this.registerCount = Preconditions.check35cAnd45ccRegisterCount(n);
        this.registerC = n > 0 ? Preconditions.checkNibbleRegister(n2) : 0;
        this.registerD = n > 1 ? Preconditions.checkNibbleRegister(n3) : 0;
        this.registerE = n > 2 ? Preconditions.checkNibbleRegister(n4) : 0;
        this.registerF = n > 3 ? Preconditions.checkNibbleRegister(n5) : 0;
        this.registerG = n > 4 ? Preconditions.checkNibbleRegister(n6) : 0;
        this.inlineIndex = Preconditions.checkInlineIndex(n7);
    }

    public static ImmutableInstruction35mi of(Instruction35mi instruction35mi) {
        if (instruction35mi instanceof ImmutableInstruction35mi) {
            return (ImmutableInstruction35mi)instruction35mi;
        }
        return new ImmutableInstruction35mi(instruction35mi.getOpcode(), instruction35mi.getRegisterCount(), instruction35mi.getRegisterC(), instruction35mi.getRegisterD(), instruction35mi.getRegisterE(), instruction35mi.getRegisterF(), instruction35mi.getRegisterG(), instruction35mi.getInlineIndex());
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    @Override
    public int getRegisterC() {
        return this.registerC;
    }

    @Override
    public int getRegisterD() {
        return this.registerD;
    }

    @Override
    public int getRegisterE() {
        return this.registerE;
    }

    @Override
    public int getRegisterF() {
        return this.registerF;
    }

    @Override
    public int getRegisterG() {
        return this.registerG;
    }

    @Override
    public int getInlineIndex() {
        return this.inlineIndex;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

