/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.Reference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.reference.ImmutableReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.reference.ImmutableReferenceFactory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction21c
extends ImmutableInstruction
implements Instruction21c {
    public static final Format FORMAT = Format.Format21c;
    protected final int registerA;
    protected final ImmutableReference reference;

    public ImmutableInstruction21c(Opcode opcode, int n, Reference reference) {
        super(opcode);
        this.registerA = Preconditions.checkByteRegister(n);
        this.reference = ImmutableReferenceFactory.of(opcode.referenceType, reference);
    }

    public static ImmutableInstruction21c of(Instruction21c instruction21c) {
        if (instruction21c instanceof ImmutableInstruction21c) {
            return (ImmutableInstruction21c)instruction21c;
        }
        return new ImmutableInstruction21c(instruction21c.getOpcode(), instruction21c.getRegisterA(), instruction21c.getReference());
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public ImmutableReference getReference() {
        return this.reference;
    }

    @Override
    public int getReferenceType() {
        return this.opcode.referenceType;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

