/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Ordering;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.ReferenceUtil;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.CharSequenceUtils;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.CollectionUtils;

public abstract class BaseMethodReference
implements MethodReference {
    @Override
    public int hashCode() {
        int n = this.getDefiningClass().hashCode();
        n = n * 31 + this.getName().hashCode();
        n = n * 31 + this.getReturnType().hashCode();
        return n * 31 + this.getParameterTypes().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof MethodReference) {
            MethodReference methodReference = (MethodReference)object;
            return this.getDefiningClass().equals(methodReference.getDefiningClass()) && this.getName().equals(methodReference.getName()) && this.getReturnType().equals(methodReference.getReturnType()) && CharSequenceUtils.listEquals(this.getParameterTypes(), methodReference.getParameterTypes());
        }
        return false;
    }

    @Override
    public int compareTo(MethodReference methodReference) {
        int n = this.getDefiningClass().compareTo(methodReference.getDefiningClass());
        if (n != 0) {
            return n;
        }
        n = this.getName().compareTo(methodReference.getName());
        if (n != 0) {
            return n;
        }
        n = this.getReturnType().compareTo(methodReference.getReturnType());
        if (n != 0) {
            return n;
        }
        return CollectionUtils.compareAsIterable(Ordering.usingToString(), this.getParameterTypes(), methodReference.getParameterTypes());
    }

    public String toString() {
        return ReferenceUtil.getMethodDescriptor(this);
    }
}

