/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexFileHolder;
import com.github.tmurakami.dexopener.DexFileHolderImpl;
import com.github.tmurakami.dexopener.DexFileOpener;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableDexFile;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RunnableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DexFileHolderMapper {
    private static final Opcodes OPCODES = Opcodes.getDefault();
    private static final int MAX_CLASSES_PER_DEX_FILE = 100;
    private final ClassNameFilter classNameFilter;
    private final DexFileOpener dexFileOpener;

    DexFileHolderMapper(ClassNameFilter classNameFilter, DexFileOpener dexFileOpener) {
        this.classNameFilter = classNameFilter;
        this.dexFileOpener = dexFileOpener;
    }

    void map(byte[] bytecode, Map<String, DexFileHolder> holderMap) {
        HashSet<Object> classesToBeOpened = new HashSet<ClassDef>();
        DexFileHolderImpl holder = new DexFileHolderImpl();
        for (ClassDef def : new DexBackedDexFile(OPCODES, bytecode).getClasses()) {
            String className = DexFileHolderMapper.dexToJavaName(def.getType());
            if (!this.classNameFilter.accept(className)) continue;
            Logger logger = Loggers.get();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Class to be opened: " + className);
            }
            classesToBeOpened.add(def);
            holderMap.put(className, holder);
            if (classesToBeOpened.size() != 100) continue;
            holder.setDexFileFuture(this.openClasses(classesToBeOpened));
            classesToBeOpened = new HashSet();
            holder = new DexFileHolderImpl();
        }
        if (!classesToBeOpened.isEmpty()) {
            holder.setDexFileFuture(this.openClasses(classesToBeOpened));
        }
    }

    private RunnableFuture<dalvik.system.DexFile> openClasses(Set<ClassDef> classesToBeOpened) {
        return this.dexFileOpener.openDexFile((DexFile)new ImmutableDexFile(OPCODES, classesToBeOpened));
    }

    private static String dexToJavaName(String dexName) {
        return dexName.substring(1, dexName.length() - 1).replace('/', '.');
    }
}

