/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderDebugItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.Label;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.Instruction;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MethodLocation {
    BuilderInstruction instruction;
    int codeAddress;
    int index;
    private List<Label> labels = null;
    private List<BuilderDebugItem> debugItems = null;

    MethodLocation(BuilderInstruction builderInstruction, int n, int n2) {
        this.instruction = builderInstruction;
        this.codeAddress = n;
        this.index = n2;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public int getCodeAddress() {
        return this.codeAddress;
    }

    private List<Label> getLabels(boolean bl) {
        if (this.labels == null) {
            if (bl) {
                this.labels = new ArrayList<Label>(1);
                return this.labels;
            }
            return ImmutableList.of();
        }
        return this.labels;
    }

    private List<BuilderDebugItem> getDebugItems(boolean bl) {
        if (this.debugItems == null) {
            if (bl) {
                this.debugItems = new ArrayList<BuilderDebugItem>(1);
                return this.debugItems;
            }
            return ImmutableList.of();
        }
        return this.debugItems;
    }

    void mergeInto(MethodLocation methodLocation) {
        List<Object> list;
        if (this.labels != null || methodLocation.labels != null) {
            list = methodLocation.getLabels(true);
            for (Label object : this.getLabels(false)) {
                object.location = methodLocation;
                list.add(object);
            }
            this.labels = null;
        }
        if (this.debugItems != null || methodLocation.labels != null) {
            list = this.getDebugItems(true);
            for (BuilderDebugItem builderDebugItem : list) {
                builderDebugItem.location = methodLocation;
            }
            list.addAll(methodLocation.getDebugItems(false));
            methodLocation.debugItems = list;
            this.debugItems = null;
        }
    }

    public Set<Label> getLabels() {
        return new AbstractSet<Label>(){

            @Override
            public Iterator<Label> iterator() {
                final Iterator iterator = MethodLocation.this.getLabels(false).iterator();
                return new Iterator<Label>(){
                    private Label currentLabel = null;

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Label next() {
                        this.currentLabel = (Label)iterator.next();
                        return this.currentLabel;
                    }

                    @Override
                    public void remove() {
                        if (this.currentLabel != null) {
                            this.currentLabel.location = null;
                        }
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return MethodLocation.this.getLabels(false).size();
            }

            @Override
            public boolean add(Label label) {
                if (label.isPlaced()) {
                    throw new IllegalArgumentException("Cannot add a label that is already placed. You must remove it from its current location first.");
                }
                label.location = MethodLocation.this;
                MethodLocation.this.getLabels(true).add(label);
                return true;
            }
        };
    }

    public Label addNewLabel() {
        Label label = new Label(this);
        this.getLabels(true).add(label);
        return label;
    }

    public Set<BuilderDebugItem> getDebugItems() {
        return new AbstractSet<BuilderDebugItem>(){

            @Override
            public Iterator<BuilderDebugItem> iterator() {
                final Iterator iterator = MethodLocation.this.getDebugItems(false).iterator();
                return new Iterator<BuilderDebugItem>(){
                    private BuilderDebugItem currentDebugItem = null;

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public BuilderDebugItem next() {
                        this.currentDebugItem = (BuilderDebugItem)iterator.next();
                        return this.currentDebugItem;
                    }

                    @Override
                    public void remove() {
                        if (this.currentDebugItem != null) {
                            this.currentDebugItem.location = null;
                        }
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return MethodLocation.this.getDebugItems(false).size();
            }

            @Override
            public boolean add(BuilderDebugItem builderDebugItem) {
                if (builderDebugItem.location != null) {
                    throw new IllegalArgumentException("Cannot add a debug item that has already been added to a method. You must remove it from its current location first.");
                }
                builderDebugItem.location = MethodLocation.this;
                MethodLocation.this.getDebugItems(true).add(builderDebugItem);
                return true;
            }
        };
    }
}

