/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueUtil;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class EncodedValueDouble
extends EncodedValue {
    private int type = 17;
    private double value;

    public EncodedValueDouble(double value) {
        this.value = value;
    }

    public EncodedValueDouble(Object value) {
        this.value = (Double)value;
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        return EncodedValueUtil.encodeZeroExtendedToRightValue(Double.doubleToRawLongBits(this.value), this.type);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueDouble) {
            EncodedValueDouble encodedValue = (EncodedValueDouble)o;
            result = this.type == encodedValue.type && this.value == encodedValue.value;
        }
        return result;
    }

    public int hashCode() {
        return this.type + (int)this.value * 849;
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        if (this == encodedValue) {
            return 0;
        }
        EncodedValueDouble ed = (EncodedValueDouble)encodedValue;
        double value2 = ed.value;
        return this.value == value2 ? 0 : (this.value > value2 ? 1 : -1);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

