/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.ClassNameFilter;

final class ClassNameFilterWrapper
implements ClassNameFilter {
    private static final String[] EXCLUDED_PACKAGES = new String[]{"android.", "com.android.", "com.github.tmurakami.classinjector.", "com.github.tmurakami.dexmockito.", "com.github.tmurakami.dexopener.", "com.github.tmurakami.mockito4k.", "java.", "javax.", "junit.", "kotlin.", "kotlinx.", "net.bytebuddy.", "org.hamcrest.", "org.jacoco.", "org.junit.", "org.mockito.", "org.objenesis."};
    private final ClassNameFilter delegate;

    ClassNameFilterWrapper(ClassNameFilter delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean accept(@NonNull String className) {
        return ClassNameFilterWrapper.isAccepted(className) && this.delegate.accept(className);
    }

    private static boolean isAccepted(String name) {
        if (name.startsWith("android.databinding.")) {
            return true;
        }
        for (String pkg : EXCLUDED_PACKAGES) {
            if (!name.startsWith(pkg)) continue;
            return false;
        }
        return !name.endsWith(".R") && !name.contains(".R$") && !name.endsWith(".BuildConfig");
    }
}

