/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class AnnotationElement
implements Comparable<AnnotationElement> {
    private final String elementName;
    private final EncodedValue encodedValue;

    public AnnotationElement(String elementName, EncodedValue encodedValue) {
        this.elementName = elementName;
        this.encodedValue = encodedValue;
    }

    public byte[] encode(ConstantPool constantPool) {
        ByteVector out = new ByteVector();
        out.putUleb128(constantPool.getStringIndex(this.elementName));
        out.putByteArray(this.encodedValue.encode(constantPool));
        return out.getData();
    }

    public String getElementName() {
        return this.elementName;
    }

    public EncodedValue getEncodedValue() {
        return this.encodedValue;
    }

    public int hashCode() {
        return (this.elementName != null ? this.elementName.hashCode() : 0) + (this.encodedValue != null ? this.encodedValue.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AnnotationElement) {
            AnnotationElement ae = (AnnotationElement)obj;
            return this.elementName.equals(ae.elementName) && this.encodedValue.equals(ae.encodedValue);
        }
        return false;
    }

    @Override
    public int compareTo(AnnotationElement ae) {
        if (this == ae) {
            return 0;
        }
        int result = this.elementName.compareTo(ae.elementName);
        if (result == 0) {
            result = this.encodedValue.compareTo(ae.encodedValue);
        }
        return result;
    }

    public String toString() {
        return this.elementName + ": " + this.encodedValue;
    }
}

