/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IIndexInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.ITwoRegistersInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.Field;

public class InstructionFormat22C
extends Instruction
implements ITwoRegistersInstruction,
IIndexInstruction {
    private static final int INSTRUCTION_SIZE = 4;
    private int registerA;
    private int registerB;
    private int indexC;
    private String type;
    private Field field;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    @Override
    public int getIndex() {
        return this.indexC;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xF;
    }

    public static int getRegisterB(int opcode) {
        return opcode >> 12 & 0xF;
    }

    public static int getIndexC(IDalvikValueReader reader) {
        return reader.ushort();
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(2);
    }

    public InstructionFormat22C(int opcode, String type, int registerA, int registerB) {
        super(opcode);
        this.registerA = registerA;
        this.registerB = registerB;
        this.type = type;
        Instruction.test4BitsLimit(registerA);
        Instruction.test4BitsLimit(registerB);
    }

    public InstructionFormat22C(int opcode, Field field, int registerA, int registerB) {
        super(opcode);
        this.registerA = registerA;
        this.registerB = registerB;
        this.field = field;
        Instruction.test4BitsLimit(registerA);
        Instruction.test4BitsLimit(registerB);
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        InstructionFormat22C.test8BitsLimit(this.registerA | this.registerB);
        out.putShort(((this.registerA & 0xF) << 8) + ((this.registerB & 0xF) << 12) + this.opcodeByte);
        int index = this.opcodeByte == 32 || this.opcodeByte == 35 ? constantPool.getTypeIndex(this.type) : constantPool.getFieldIndex(this.field);
        out.putShort(index);
    }
}

