/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class EncodedValueBoolean
extends EncodedValue {
    private int type = 31;
    private boolean value;

    public EncodedValueBoolean(boolean value) {
        this.value = value;
    }

    public EncodedValueBoolean(Object value) {
        this.value = (Boolean)value;
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        return new byte[]{(byte)(31 + (Boolean.valueOf(this.value) != false ? 32 : 0))};
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueBoolean) {
            EncodedValueBoolean encodedValue = (EncodedValueBoolean)o;
            result = this.type == encodedValue.type && this.value == encodedValue.value;
        }
        return result;
    }

    public int hashCode() {
        return this.type + (this.value ? 1 : 0);
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        EncodedValueBoolean eb = (EncodedValueBoolean)encodedValue;
        return this.value == eb.value ? 0 : (this.value ? 1 : -1);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

