/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IOffsetInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IPseudoInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class PseudoInstructionFillArrayData
extends Instruction
implements IPseudoInstruction {
    private static final int FILL_ARRAY_DATA_OPCODE = 768;
    private int elementWidth;
    private Object[] dataArray;
    private int type = -1;
    private IOffsetInstruction instructionFillArrayData;

    @Override
    public IOffsetInstruction getSourceInstruction() {
        return this.instructionFillArrayData;
    }

    public PseudoInstructionFillArrayData(Object[] dataArray, IOffsetInstruction instructionFillArrayData) {
        super(768);
        this.dataArray = dataArray;
        this.instructionFillArrayData = instructionFillArrayData;
        this.setElementWidthAndType();
    }

    @Override
    public int getSize() {
        return ((this.dataArray.length * this.elementWidth + 1) / 2 + 4) * 2;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putShort(768);
        out.putShort(this.elementWidth);
        int size = this.dataArray.length;
        out.putInt(size);
        switch (this.type) {
            case 0: {
                for (int i = 0; i < size; ++i) {
                    out.putByte(((Byte)this.dataArray[i]).byteValue());
                }
                if (size % 2 != 1) break;
                out.putByte(0);
                break;
            }
            case 2: {
                for (int i = 0; i < size; ++i) {
                    out.putShort(((Short)this.dataArray[i]).shortValue());
                }
                break;
            }
            case 3: {
                for (int i = 0; i < size; ++i) {
                    out.putShort(((Character)this.dataArray[i]).charValue());
                }
                break;
            }
            case 4: {
                for (int i = 0; i < size; ++i) {
                    out.putInt((Integer)this.dataArray[i]);
                }
                break;
            }
            case 16: {
                for (int i = 0; i < size; ++i) {
                    out.putInt(Float.floatToRawIntBits(((Float)this.dataArray[i]).floatValue()));
                }
                break;
            }
            case 17: {
                for (int i = 0; i < size; ++i) {
                    out.putLong(Double.doubleToRawLongBits((Double)this.dataArray[i]));
                }
                break;
            }
            case 6: {
                for (int i = 0; i < size; ++i) {
                    out.putLong((Long)this.dataArray[i]);
                }
                break;
            }
            case 31: {
                for (int i = 0; i < size; ++i) {
                    out.putByte((Boolean)this.dataArray[i] != false ? -1 : 0);
                }
                if (size % 2 != 1) break;
                out.putByte(0);
            }
        }
    }

    private void setElementWidthAndType() {
        Object value = this.dataArray[0];
        if (value instanceof Integer) {
            this.elementWidth = 4;
            this.type = 4;
        } else if (value instanceof Boolean) {
            this.elementWidth = 1;
            this.type = 31;
        } else if (value instanceof Byte) {
            this.elementWidth = 1;
            this.type = 0;
        } else if (value instanceof Character) {
            this.elementWidth = 2;
            this.type = 3;
        } else if (value instanceof Double) {
            this.elementWidth = 8;
            this.type = 17;
        } else if (value instanceof Float) {
            this.elementWidth = 4;
            this.type = 16;
        } else if (value instanceof Long) {
            this.elementWidth = 8;
            this.type = 6;
        } else if (value instanceof Short) {
            this.elementWidth = 2;
            this.type = 2;
        } else {
            throw new IllegalArgumentException("Array of this type can't be encoded.");
        }
    }
}

