/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.ILiteralInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IOneRegisterInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat21S
extends Instruction
implements IOneRegisterInstruction,
ILiteralInstruction {
    private static final int INSTRUCTION_SIZE = 4;
    private int registerA;
    private int literalB;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getLiteral() {
        return this.literalB;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xFF;
    }

    public static int getLiteralB(IDalvikValueReader reader) {
        return reader.sshort();
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(2);
    }

    public InstructionFormat21S(int opcode, int destinationRegister, int var) {
        super(opcode);
        this.registerA = destinationRegister;
        this.literalB = var;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        InstructionFormat21S.test8BitsLimit(this.registerA);
        out.putShort(((this.registerA & 0xFF) << 8) + this.opcodeByte);
        out.putShort(this.literalB & 0xFFFF);
    }
}

