/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueArray;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueBoolean;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueByte;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueCharacter;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueDouble;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueEnum;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueField;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueFloat;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueInteger;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueLong;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueMethod;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueNull;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueShort;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueString;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueType;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueUtil;

public class EncodedValueFactory {
    public static EncodedValue getEncodedValue(Object value, String desc) {
        int type = EncodedValueUtil.getTypeFromDescriptor(desc);
        return EncodedValueFactory.getEncodedValue(value, type);
    }

    public static EncodedValue getEncodedValue(Object value, int type) {
        EncodedValue encodedValue = null;
        switch (type) {
            case 0: {
                encodedValue = new EncodedValueByte(value);
                break;
            }
            case 2: {
                encodedValue = new EncodedValueShort(value);
                break;
            }
            case 3: {
                encodedValue = new EncodedValueCharacter(value);
                break;
            }
            case 4: {
                encodedValue = new EncodedValueInteger(value);
                break;
            }
            case 6: {
                encodedValue = new EncodedValueLong(value);
                break;
            }
            case 16: {
                encodedValue = new EncodedValueFloat(value);
                break;
            }
            case 17: {
                encodedValue = new EncodedValueDouble(value);
                break;
            }
            case 23: {
                encodedValue = new EncodedValueString((String)value);
                break;
            }
            case 24: {
                encodedValue = new EncodedValueType(value);
                break;
            }
            case 25: {
                encodedValue = new EncodedValueField(value);
                break;
            }
            case 26: {
                encodedValue = new EncodedValueMethod(value);
                break;
            }
            case 27: {
                encodedValue = new EncodedValueEnum(value);
                break;
            }
            case 28: {
                encodedValue = new EncodedValueArray();
                break;
            }
            case 29: {
                encodedValue = new EncodedValueAnnotation(value);
                break;
            }
            case 30: {
                encodedValue = new EncodedValueNull();
                break;
            }
            case 31: {
                encodedValue = new EncodedValueBoolean(value);
                break;
            }
            default: {
                try {
                    throw new Exception("Unknown type for this value.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return encodedValue;
    }

    public static EncodedValue getEncodedEmptyValue(String desc) {
        EncodedValue encodedValue = null;
        if (EncodedValueUtil.isTypeAReference(desc)) {
            encodedValue = new EncodedValueNull();
        } else {
            int type = EncodedValueUtil.getTypeFromDescriptor(desc);
            encodedValue = EncodedValueFactory.getEncodedValue((Object)0, type);
        }
        return encodedValue;
    }

    public static EncodedValue getEncodedNullValue() {
        return new EncodedValueNull();
    }

    public static EncodedValue getEncodedValue(Object value) {
        if (value instanceof Integer) {
            return new EncodedValueInteger(value);
        }
        if (value instanceof Boolean) {
            return new EncodedValueBoolean(value);
        }
        if (value instanceof Byte) {
            return new EncodedValueByte(value);
        }
        if (value instanceof Character) {
            return new EncodedValueCharacter(value);
        }
        if (value instanceof Double) {
            return new EncodedValueDouble(value);
        }
        if (value instanceof Float) {
            return new EncodedValueFloat(value);
        }
        if (value instanceof Long) {
            return new EncodedValueLong(value);
        }
        if (value instanceof Short) {
            return new EncodedValueShort(value);
        }
        if (value instanceof String) {
            return new EncodedValueString((String)value);
        }
        if (value instanceof int[]) {
            int[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            for (int v : array = (int[])value) {
                encodedArray.addEncodedValue(new EncodedValueInteger(v));
            }
            return encodedArray;
        }
        if (value instanceof boolean[]) {
            boolean[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            for (boolean v : array = (boolean[])value) {
                encodedArray.addEncodedValue(new EncodedValueBoolean(v));
            }
            return encodedArray;
        }
        if (value instanceof byte[]) {
            byte[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            for (byte v : array = (byte[])value) {
                encodedArray.addEncodedValue(new EncodedValueByte(v));
            }
            return encodedArray;
        }
        if (value instanceof char[]) {
            char[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            for (char v : array = (char[])value) {
                encodedArray.addEncodedValue(new EncodedValueCharacter(v));
            }
            return encodedArray;
        }
        if (value instanceof double[]) {
            double[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            for (double v : array = (double[])value) {
                encodedArray.addEncodedValue(new EncodedValueDouble(v));
            }
            return encodedArray;
        }
        if (value instanceof float[]) {
            float[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            for (float v : array = (float[])value) {
                encodedArray.addEncodedValue(new EncodedValueFloat(v));
            }
            return encodedArray;
        }
        if (value instanceof long[]) {
            long[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            for (long v : array = (long[])value) {
                encodedArray.addEncodedValue(new EncodedValueLong(v));
            }
            return encodedArray;
        }
        if (value instanceof short[]) {
            short[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            for (short v : array = (short[])value) {
                encodedArray.addEncodedValue(new EncodedValueShort(v));
            }
            return encodedArray;
        }
        if (value instanceof String[]) {
            String[] array;
            EncodedValueArray encodedArray = new EncodedValueArray();
            for (String v : array = (String[])value) {
                encodedArray.addEncodedValue(new EncodedValueString(v));
            }
            return encodedArray;
        }
        try {
            throw new Exception("Unable to find the type of this Value.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

