/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.ClassNameFilters;
import com.github.tmurakami.dexopener.DexClassFileFactory;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexOpener;
import com.github.tmurakami.dexopener.DexOpenerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class DexOpenerBuilderImpl
implements DexOpener.Builder {
    private final List<ClassNameFilter> classNameFilters = new ArrayList<ClassNameFilter>();
    private final DexFileLoader dexFileLoader;
    private final DexClassFileFactory dexClassFileFactory;

    DexOpenerBuilderImpl(DexFileLoader dexFileLoader, DexClassFileFactory dexClassFileFactory) {
        this.dexFileLoader = dexFileLoader;
        this.dexClassFileFactory = dexClassFileFactory;
    }

    @Override
    @NonNull
    public DexOpener.Builder classNameFilters(ClassNameFilter ... filters) {
        for (ClassNameFilter f : filters) {
            if (f == null) {
                throw new IllegalArgumentException("'filters' contains null");
            }
            this.classNameFilters.add(f);
        }
        return this;
    }

    @Override
    @NonNull
    public DexOpener build() {
        List<ClassNameFilter> filters = Collections.unmodifiableList(this.classNameFilters);
        return new DexOpenerImpl(new ClassNameFilters(filters), this.dexFileLoader, this.dexClassFileFactory);
    }
}

