/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Instrumentation;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.github.tmurakami.classinjector.ClassInjector;
import com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.ClassSourceImpl;
import com.github.tmurakami.dexopener.DexClassSourceFactory;
import com.github.tmurakami.dexopener.DexOpener;
import java.io.File;
import java.util.logging.Logger;

final class DexOpenerImpl
extends DexOpener {
    private final Instrumentation instrumentation;
    private final ClassNameFilter classNameFilter;

    DexOpenerImpl(Instrumentation instrumentation, ClassNameFilter classNameFilter) {
        this.instrumentation = instrumentation;
        this.classNameFilter = classNameFilter;
    }

    @Override
    public void install() {
        Context context = this.instrumentation.getTargetContext();
        if (context.getApplicationContext() != null) {
            throw new IllegalStateException("An Application instance has already been created");
        }
        ApplicationInfo ai = context.getApplicationInfo();
        File cacheDir = new File(ai.dataDir, "code_cache/dexopener");
        if (cacheDir.isDirectory()) {
            DexOpenerImpl.deleteFiles(cacheDir.listFiles());
        }
        DexClassSourceFactory dexClassSourceFactory = new DexClassSourceFactory(cacheDir);
        ClassInjector.from((ClassSource)new ClassSourceImpl(ai.sourceDir, this.classNameFilter, dexClassSourceFactory)).into(context.getClassLoader());
    }

    private static void deleteFiles(File[] files) {
        for (File f : files) {
            if (f.isDirectory()) {
                DexOpenerImpl.deleteFiles(f.listFiles());
            }
            if (!f.exists() || f.delete()) continue;
            Logger.getLogger("com.github.tmurakami.dexopener").warning("Cannot delete " + f);
        }
    }
}

