/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.classinjector.ClassFile;
import com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.classinjector.ClassSources;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexClassSource;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class ClassSourceImpl
implements ClassSource {
    private final String sourceDir;
    private final ClassNameFilter classNameFilter;
    private final DexClassSource.Factory dexClassSourceFactory;
    private ClassSource delegate;

    ClassSourceImpl(String sourceDir, ClassNameFilter classNameFilter, DexClassSource.Factory dexClassSourceFactory) {
        this.sourceDir = sourceDir;
        this.classNameFilter = classNameFilter;
        this.dexClassSourceFactory = dexClassSourceFactory;
    }

    public ClassFile getClassFile(String className) throws IOException {
        return this.classNameFilter.accept(className) ? this.getDelegate().getClassFile(className) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassSource getDelegate() throws IOException {
        if (this.delegate != null) {
            return this.delegate;
        }
        ArrayList<ClassSource> sources = new ArrayList<ClassSource>();
        ZipInputStream in = new ZipInputStream(new FileInputStream(this.sourceDir));
        try {
            ZipEntry e;
            while ((e = in.getNextEntry()) != null) {
                int l;
                String name = e.getName();
                if (!name.startsWith("classes") || !name.endsWith(".dex")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[16384];
                while ((l = in.read(buffer)) != -1) {
                    out.write(buffer, 0, l);
                }
                sources.add(this.dexClassSourceFactory.create(out.toByteArray()));
            }
        }
        finally {
            in.close();
        }
        this.delegate = new ClassSources(sources);
        return this.delegate;
    }
}

