/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.TypeList;
import java.util.ArrayList;

public class Prototype
implements Comparable<Prototype> {
    private final String descriptor;
    private String shortyDescriptor;
    private String returnType;
    private TypeList parameterTypes;
    private final int hashcode;

    public Prototype(String descriptor) {
        this.descriptor = descriptor;
        this.hashcode = Prototype.calculateHashCode(descriptor);
    }

    public void initialize() {
        this.shortyDescriptor = Prototype.getShortyDescriptorFromTypeDescriptor(this.descriptor);
        this.returnType = Prototype.getFirstDescriptor(this.descriptor);
        this.parameterTypes = Prototype.getDescriptors(this.descriptor, true);
    }

    public static int calculateHashCode(String descriptor) {
        return descriptor.hashCode();
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getShortyDescriptor() {
        return this.shortyDescriptor;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public TypeList getParameterTypes() {
        return this.parameterTypes;
    }

    public int getNbParameters() {
        return this.parameterTypes.size();
    }

    public static String getFirstDescriptor(String descriptor) {
        StringBuilder result = new StringBuilder(10);
        if (descriptor != null && descriptor.length() > 0) {
            char c = descriptor.charAt(0);
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    result.append(c);
                    break;
                }
                case 'L': {
                    int i = descriptor.indexOf(59);
                    if (i <= 0) break;
                    result.append(descriptor.substring(0, i + 1));
                    break;
                }
                case '[': {
                    result.append('[');
                    result.append(Prototype.getFirstDescriptor(descriptor.substring(1)));
                }
            }
        }
        return result.toString();
    }

    public static int getSizeOfType(String type) {
        int result = 0;
        switch (type.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                result = 2;
                break;
            }
            case 'D': 
            case 'J': {
                result = 4;
            }
        }
        return result;
    }

    public static int getSizeOfDescriptor(String descriptor, boolean skipReturnType) {
        int result = 0;
        while (descriptor != null && descriptor.length() > 0) {
            String foundDescriptor = Prototype.getFirstDescriptor(descriptor);
            if (foundDescriptor == null) {
                descriptor = null;
                continue;
            }
            int foundResult = Prototype.getSizeOfType(foundDescriptor);
            if (skipReturnType) {
                skipReturnType = false;
            } else {
                result += foundResult;
            }
            descriptor = descriptor.substring(foundDescriptor.length());
        }
        return result;
    }

    public static String getShortyDescriptorFromTypeDescriptor(String desc) {
        StringBuilder result = new StringBuilder(5);
        while (!desc.equals("")) {
            String foundDesc = Prototype.getFirstDescriptor(desc);
            desc = desc.substring(foundDesc.length());
            if (foundDesc.length() > 1) {
                result.append('L');
                continue;
            }
            result.append(foundDesc);
        }
        return result.toString();
    }

    public static int getNbParametersFromTypeDescriptor(String desc) {
        return Prototype.getShortyDescriptorFromTypeDescriptor(desc).length() - 1;
    }

    public static TypeList getDescriptors(String descriptor, boolean skipFirst) {
        ArrayList<String> types = new ArrayList<String>();
        while (!descriptor.equals("")) {
            String foundDesc = Prototype.getFirstDescriptor(descriptor);
            descriptor = descriptor.substring(foundDesc.length());
            if (skipFirst) {
                skipFirst = false;
                continue;
            }
            types.add(foundDesc);
        }
        return new TypeList(types.toArray(new String[types.size()]));
    }

    @Override
    public int compareTo(Prototype prototype) {
        if (this == prototype) {
            return 0;
        }
        int compare = this.returnType.compareTo(prototype.returnType);
        if (compare != 0) {
            return compare;
        }
        return this.parameterTypes.compareTo(prototype.parameterTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Prototype) {
            Prototype secondPrototype = (Prototype)o;
            return this.descriptor.equals(secondPrototype.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

