/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureCommon.Label;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;
import java.util.ArrayList;
import java.util.List;

public class EncodedCatchHandler {
    private final ConstantPool constantPool;
    private int sizeCatchTypes = 0;
    private Label catchAllHandler;
    private List<String> types = new ArrayList<String>();
    private List<Label> exceptionHandlers = new ArrayList<Label>();

    public EncodedCatchHandler(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void addTypeAddrPair(String type, Label exceptionHandler) {
        if (type == null) {
            this.catchAllHandler = exceptionHandler;
        } else {
            this.types.add(type);
            this.exceptionHandlers.add(exceptionHandler);
            ++this.sizeCatchTypes;
        }
    }

    public void write(ByteVector out) {
        boolean hasCatchAll = this.catchAllHandler != null;
        out.putSleb128(hasCatchAll ? -this.sizeCatchTypes : this.sizeCatchTypes);
        int size = this.types.size();
        for (int i = 0; i < size; ++i) {
            int typeIndex = this.constantPool.getTypeIndex(this.types.get(i));
            out.putUleb128(typeIndex);
            out.putUleb128(this.exceptionHandlers.get(i).getOffset() / 2);
        }
        if (hasCatchAll) {
            out.putUleb128(this.catchAllHandler.getOffset() / 2);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof EncodedCatchHandler) {
            EncodedCatchHandler ech = (EncodedCatchHandler)obj;
            if (this.catchAllHandler == null) {
                result = ech.catchAllHandler == null;
            } else {
                boolean bl = result = ech.catchAllHandler == null ? false : this.catchAllHandler.equals(ech.catchAllHandler);
            }
            if (result) {
                result = this.types.equals(ech.types) && this.exceptionHandlers.equals(ech.exceptionHandlers);
            }
        }
        return result;
    }

    public int hashCode() {
        int result = this.catchAllHandler == null ? 0 : this.catchAllHandler.hashCode();
        for (String type : this.types) {
            if (type == null) continue;
            result += type.hashCode();
        }
        for (Label label : this.exceptionHandlers) {
            result += label.hashCode();
        }
        return result;
    }
}

