/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IOffsetInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IOneRegisterInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureCommon.Label;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat31T
extends Instruction
implements IOneRegisterInstruction,
IOffsetInstruction {
    private static final int INSTRUCTION_SIZE = 6;
    private int registerA;
    private int offsetB;
    private int instructionOffset;
    private Label label;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getOffset() {
        return this.offsetB;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xFF;
    }

    public static int getOffset(IDalvikValueReader reader, int opcode) {
        int opcodeOffset = reader.getPos() - 2;
        return reader.sint() * 2 + opcodeOffset;
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(4);
    }

    public InstructionFormat31T(int opcode, Label label, int register, int instructionOffset) {
        super(opcode);
        this.instructionOffset = instructionOffset;
        this.label = label;
        this.registerA = register;
    }

    @Override
    public int getSize() {
        return 6;
    }

    @Override
    public int getInstructionOffset() {
        return this.instructionOffset;
    }

    @Override
    public void setInstructionOffset(int instructionOffset) {
        this.instructionOffset = instructionOffset;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        InstructionFormat31T.test8BitsLimit(this.registerA);
        out.putShort(((this.registerA & 0xFF) << 8) + this.opcodeByte);
        int branchOffset = (this.label.getOffset() - this.instructionOffset) / 2;
        out.putShort(branchOffset & 0xFFFF);
        out.putShort(branchOffset >> 16 & 0xFFFF);
    }
}

