/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IOffsetInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureCommon.Label;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat30T
extends Instruction
implements IOffsetInstruction {
    private static final int INSTRUCTION_SIZE = 6;
    private int offset;
    private int instructionOffset;
    private Label label;

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    public static int getOffset(IDalvikValueReader reader, int opcode) {
        int readOffset = reader.sint() * 2;
        return reader.getPos() - 6 + readOffset;
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(4);
    }

    public InstructionFormat30T(int opcode, Label label, int instructionOffset) {
        super(opcode);
        this.label = label;
        this.instructionOffset = instructionOffset;
    }

    @Override
    public int getSize() {
        return 6;
    }

    @Override
    public int getInstructionOffset() {
        return this.instructionOffset;
    }

    @Override
    public void setInstructionOffset(int instructionOffset) {
        this.instructionOffset = instructionOffset;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putShort(this.opcodeByte);
        int branchOffset = (this.label.getOffset() - this.instructionOffset) / 2;
        out.putShort(branchOffset & 0xFFFF);
        out.putShort(branchOffset >> 16 & 0xFFFF);
    }
}

