/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.ITwoRegistersInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat12X
extends Instruction
implements ITwoRegistersInstruction {
    private static final int INSTRUCTION_SIZE = 2;
    private int registerA;
    private int registerB;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xF;
    }

    public static int getRegisterB(int opcode) {
        return opcode >> 12 & 0xF;
    }

    public InstructionFormat12X(int opcode, int destinationRegister, int var) {
        super(opcode);
        this.registerA = destinationRegister;
        this.registerB = var;
        Instruction.test4BitsLimit(this.registerA);
        Instruction.test4BitsLimit(this.registerB);
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        InstructionFormat12X.test4BitsLimit(this.registerA | this.registerB);
        int firstShort = ((this.registerB & 0xF) << 12) + ((this.registerA & 0xF) << 8) + this.opcodeByte;
        out.putShort(firstShort);
    }
}

