/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.AnnotationVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.AnnotationWriter;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationWriter;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ClassVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.FieldVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.FieldWriter;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.MethodVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.MethodWriter;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueArray;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueFactory;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueType;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.AnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.AnnotationItem;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ClassDefinitionItem;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.Field;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.Method;
import java.util.List;

public class ClassWriter
extends ClassVisitor {
    private ApplicationWriter applicationWriter;
    private ConstantPool constantPool;
    private ClassDefinitionItem classDefinitionItem;
    private Method enclosingMethod = null;

    public ClassWriter(ApplicationWriter applicationWriter, ConstantPool constantPool, int access, String name, String[] signature, String superName, String[] interfaces) {
        super(262144);
        this.applicationWriter = applicationWriter;
        this.constantPool = constantPool;
        this.classDefinitionItem = constantPool.addClassToConstantPool(name, superName, access, interfaces, signature);
    }

    public ApplicationWriter getApplicationWriter() {
        return this.applicationWriter;
    }

    public String getName() {
        return this.classDefinitionItem.getClassName();
    }

    public ClassDefinitionItem getClassDefinitionItem() {
        return this.classDefinitionItem;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    @Override
    public void visit(int version, int access, String name, String[] signature, String superName, String[] interfaces) {
        int size;
        String[] savedSignature = this.classDefinitionItem.getSignature();
        if (savedSignature != null && (size = savedSignature.length) > 0) {
            AnnotationVisitor av = this.visitAnnotation("Ldalvik/annotation/Signature;", false);
            AnnotationVisitor subAv = av.visitArray("value");
            for (String string : savedSignature) {
                subAv.visit(null, string);
            }
            subAv.visitEnd();
            av.visitEnd();
        }
    }

    @Override
    public void visitSource(String source, String debug) {
        this.classDefinitionItem.setSourceFileName(source);
        this.constantPool.addStringToConstantPool(source);
    }

    @Override
    public void visitEnd() {
        List<AnnotationItem> defaultAnnotationItems;
        EncodedValueArray array = this.classDefinitionItem.getMemberClassArray();
        if (array != null) {
            String val = "value";
            this.constantPool.addStringToConstantPool(val);
            this.constantPool.addTypeToConstantPool("Ldalvik/annotation/MemberClasses;");
            AnnotationItem annotationItem = new AnnotationItem(2, "Ldalvik/annotation/MemberClasses;");
            AnnotationElement annotationElement = new AnnotationElement(val, array);
            annotationItem.addAnnotationElement(annotationElement);
            this.classDefinitionItem.addAnnotationItem(annotationItem);
            this.constantPool.addAnnotationItemToConstantPool(annotationItem);
        }
        if ((defaultAnnotationItems = this.classDefinitionItem.getAnnotationItemsForDefaultAnnotation()) != null && defaultAnnotationItems.size() > 0) {
            EncodedValueAnnotation createdEncodedValueAnnotation = null;
            String encodedAnnotationType = null;
            for (AnnotationItem annotationItems : defaultAnnotationItems) {
                for (AnnotationElement currentElement : annotationItems.getAnnotationElements()) {
                    EncodedValueAnnotation currentEncodedValue = (EncodedValueAnnotation)currentElement.getEncodedValue();
                    encodedAnnotationType = currentEncodedValue.getAnnotationType();
                    if (createdEncodedValueAnnotation == null) {
                        createdEncodedValueAnnotation = new EncodedValueAnnotation(encodedAnnotationType);
                    }
                    for (AnnotationElement currentAnnotationElement : currentEncodedValue.getAnnotationElements()) {
                        createdEncodedValueAnnotation.addAnnotationElement(currentAnnotationElement);
                    }
                }
            }
            AnnotationItem createdAnnotationItem = new AnnotationItem(2, "Ldalvik/annotation/AnnotationDefault;");
            AnnotationElement createdAnnotationElement = new AnnotationElement("value", createdEncodedValueAnnotation);
            createdAnnotationItem.addAnnotationElement(createdAnnotationElement);
            this.classDefinitionItem.addAnnotationItem(createdAnnotationItem);
            this.constantPool.addAnnotationItemToConstantPool(createdAnnotationItem);
        }
        this.constantPool.addAnnotationSetItemToConstantPool(this.classDefinitionItem.getAnnotationSetItem());
        this.classDefinitionItem.buildAnnotationDirectoryItem();
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String[] signature, String[] exceptions) {
        int size;
        String[] savedSignature;
        MethodWriter methodWriter = new MethodWriter(this, access, name, desc, signature, exceptions);
        Method method = methodWriter.getMethod();
        this.classDefinitionItem.addMethod(method);
        if (method.isUsingThis()) {
            this.constantPool.addStringToConstantPool("this");
        }
        if ((savedSignature = method.getSignature()) != null && (size = savedSignature.length) > 0) {
            AnnotationVisitor av = methodWriter.visitAnnotation("Ldalvik/annotation/Signature;", false);
            String[] subAv = av.visitArray("value");
            String[] stringArray = savedSignature;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                subAv.visit(null, string);
            }
            subAv.visitEnd();
            av.visitEnd();
        }
        if (exceptions != null && exceptions.length > 0) {
            String valString = "value";
            this.constantPool.addStringToConstantPool(valString);
            this.constantPool.addTypeToConstantPool("Ldalvik/annotation/Throws;");
            EncodedValueArray array = new EncodedValueArray();
            for (String exception : exceptions) {
                this.constantPool.addTypeToConstantPool(exception);
                EncodedValueType value = new EncodedValueType(exception);
                array.addEncodedValue(value);
            }
            AnnotationElement annotationElement = new AnnotationElement(valString, array);
            AnnotationItem annotationItem = new AnnotationItem(2, "Ldalvik/annotation/Throws;");
            annotationItem.addAnnotationElement(annotationElement);
            method.addAnnotationItem(annotationItem);
            this.constantPool.addAnnotationItemToConstantPool(annotationItem);
        }
        return methodWriter;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String[] signature, Object value) {
        int size;
        FieldWriter fieldWriter = new FieldWriter(this.constantPool, this.getName(), access, name, desc, signature, value);
        Field field = fieldWriter.getField();
        this.classDefinitionItem.addField(field);
        String[] savedSignature = field.getSignature();
        if (savedSignature != null && (size = savedSignature.length) > 0) {
            AnnotationVisitor av = fieldWriter.visitAnnotation("Ldalvik/annotation/Signature;", false);
            AnnotationVisitor subAv = av.visitArray("value");
            for (String string : savedSignature) {
                subAv.visit(null, string);
            }
            subAv.visitEnd();
            av.visitEnd();
        }
        return fieldWriter;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationWriter annotationWriter = AnnotationWriter.createAnnotationWriter(desc, visible, this.constantPool, null);
        this.classDefinitionItem.addAnnotationItem(annotationWriter.getAnnotationItem());
        return annotationWriter;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (name == null) {
            this.constantPool.addStringToConstantPool(outerName);
        } else {
            this.constantPool.addTypeToConstantPool(name);
            this.constantPool.addTypeToConstantPool(outerName);
            this.constantPool.addStringToConstantPool(innerName);
        }
        boolean isEnclosingClass = this.enclosingMethod == null;
        String annotationType = isEnclosingClass ? "Ldalvik/annotation/EnclosingClass;" : "Ldalvik/annotation/EnclosingMethod;";
        String val = "value";
        this.constantPool.addStringToConstantPool(val);
        this.constantPool.addTypeToConstantPool(annotationType);
        AnnotationItem annotationItem = new AnnotationItem(2, annotationType);
        EncodedValue encodedValue = isEnclosingClass ? EncodedValueFactory.getEncodedValue((Object)outerName, 24) : EncodedValueFactory.getEncodedValue((Object)this.enclosingMethod, 26);
        AnnotationElement annotationElement = new AnnotationElement(val, encodedValue);
        annotationItem.addAnnotationElement(annotationElement);
        this.constantPool.addAnnotationItemToConstantPool(annotationItem);
        this.classDefinitionItem.addAnnotationItem(annotationItem);
        annotationItem = new AnnotationItem(2, "Ldalvik/annotation/InnerClass;");
        val = "name";
        this.constantPool.addStringToConstantPool(val);
        this.constantPool.addTypeToConstantPool("Ldalvik/annotation/InnerClass;");
        encodedValue = innerName == null ? EncodedValueFactory.getEncodedNullValue() : EncodedValueFactory.getEncodedValue((Object)innerName, 23);
        annotationElement = new AnnotationElement(val, encodedValue);
        annotationItem.addAnnotationElement(annotationElement);
        val = "accessFlags";
        this.constantPool.addStringToConstantPool(val);
        encodedValue = EncodedValueFactory.getEncodedValue((Object)access, 4);
        annotationElement = new AnnotationElement(val, encodedValue);
        annotationItem.addAnnotationElement(annotationElement);
        this.constantPool.addAnnotationItemToConstantPool(annotationItem);
        this.classDefinitionItem.addAnnotationItem(annotationItem);
    }

    @Override
    public void visitMemberClass(String name, String outerName, String innerName) {
        if (name != null) {
            this.constantPool.addTypeToConstantPool(name);
        }
        this.classDefinitionItem.addMemberClassValue(name, this.constantPool);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.enclosingMethod = this.constantPool.addMethodToConstantPool(name, owner, desc, 262144, null, null);
    }

    @Override
    public void visitAttribute(Object attr) {
    }
}

