/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.github.tmurakami.dexopener.ClassLoaderFactory;
import com.github.tmurakami.dexopener.ClassLoaderHelper;
import com.github.tmurakami.dexopener.DexElement;
import com.github.tmurakami.dexopener.DexElementFactory;
import com.github.tmurakami.dexopener.IOUtils;
import com.github.tmurakami.dexopener.Installer;
import java.io.File;

final class InstallerImpl
extends Installer {
    private final DexElementFactory elementFactory;
    private final ClassLoaderFactory classLoaderFactory;
    private final ClassLoaderHelper classLoaderHelper;

    InstallerImpl(DexElementFactory elementFactory, ClassLoaderFactory classLoaderFactory, ClassLoaderHelper classLoaderHelper) {
        this.elementFactory = elementFactory;
        this.classLoaderFactory = classLoaderFactory;
        this.classLoaderHelper = classLoaderHelper;
    }

    @Override
    public void install(Context context) {
        ApplicationInfo ai = context.getApplicationInfo();
        File cacheDir = new File(ai.dataDir, "code_cache/dexopener");
        IOUtils.forceDelete(cacheDir);
        if (!cacheDir.mkdirs()) {
            throw new Error("Cannot create " + cacheDir);
        }
        DexElement element = this.elementFactory.newDexElement(new File(ai.sourceDir), cacheDir);
        ClassLoader classLoader = context.getClassLoader();
        this.classLoaderHelper.setParent(classLoader, this.classLoaderFactory.newClassLoader(classLoader, element));
    }
}

